/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.core.block.entity.EnderAirTile;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreTileEntities;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class EnderAirBlock
extends AirBlock
implements EntityBlock {
    protected static boolean teleport = true;
    protected static int duration = 40;

    public EnderAirBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnderAirTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> actualType) {
        return ITickableTile.createTicker(level, actualType, (BlockEntityType)CoreTileEntities.ENDER_AIR_TILE.get(), EnderAirTile.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(8) == 0) {
            Utils.spawnBlockParticlesClient(worldIn, (ParticleOptions)ParticleTypes.f_123760_, pos, rand, 2);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!teleport || Utils.isClientWorld(worldIn)) {
            return;
        }
        if (entityIn instanceof ItemEntity || entityIn instanceof ExperienceOrb) {
            return;
        }
        BlockPos randPos = pos.m_7918_(-128 + worldIn.f_46441_.m_188503_(257), worldIn.f_46441_.m_188503_(8), -128 + worldIn.f_46441_.m_188503_(257));
        if (!worldIn.m_8055_(randPos).m_60767_().m_76333_()) {
            if (entityIn instanceof LivingEntity) {
                if (Utils.teleportEntityTo(entityIn, randPos)) {
                    ((LivingEntity)entityIn).m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.ENDERFERENCE.get(), duration, 0, false, false));
                }
            } else if (worldIn.m_46467_() % (long)duration == 0L) {
                entityIn.m_6034_((double)randPos.m_123341_(), (double)randPos.m_123342_(), (double)randPos.m_123343_());
                entityIn.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
    }
}

