/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.kubeutils.kubejs.events;

import dev.latvian.mods.kubejs.item.ItemHandlerUtils;
import dev.latvian.mods.kubejs.player.PlayerEventJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import pro.mikey.kubeutils.events.KuEvents;
import pro.mikey.kubeutils.utils.Utils;
import pro.mikey.kubeutils.utils.annotations.KuEvent;

@KuEvent(value=KuEvents.PLAYER_STARTER_ITEMS)
public class PlayerStarterItems
extends PlayerEventJS {
    public static final String STARTER_ITEMS_GIVEN_FLAG = Utils.kuIdStorage("sig");
    private final Player player;
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private final Map<EquipmentSlot, ItemStack> armorItems = new HashMap<EquipmentSlot, ItemStack>();
    public String triggeredFrom = "join";

    public PlayerStarterItems(Player player) {
        this.player = player;
    }

    public PlayerStarterItems(Player player, String triggeredFrom) {
        this.player = player;
        this.triggeredFrom = triggeredFrom;
    }

    public void addItems(ItemStack ... items) {
        this.items.addAll(List.of(items));
    }

    public void addEquipmentItem(String equipmentSlot, ItemStack item) {
        EquipmentSlot slot = Arrays.stream(EquipmentSlot.values()).filter(e -> e.m_20751_().equalsIgnoreCase(equipmentSlot)).findFirst().orElse(EquipmentSlot.CHEST);
        this.armorItems.put(slot, item);
    }

    protected void afterPosted(boolean cancelled) {
        if (cancelled) {
            return;
        }
        boolean inserted = false;
        if (this.items.size() > 0) {
            this.items.forEach(item -> ItemHandlerUtils.giveItemToPlayer((Player)this.player, (ItemStack)item, (int)-1));
            inserted = true;
        }
        if (this.armorItems.size() > 0) {
            this.armorItems.forEach((key, value) -> {
                this.player.m_8061_(key, value);
                if (this.player.m_6844_(key).m_41720_() != value.m_41720_()) {
                    ItemHandlerUtils.giveItemToPlayer((Player)this.player, (ItemStack)value, (int)-1);
                }
            });
            inserted = true;
        }
        if (inserted) {
            this.player.kjs$getPersistentData().m_128379_(STARTER_ITEMS_GIVEN_FLAG, true);
        }
    }

    public Player getEntity() {
        return this.player;
    }
}

