/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntangledBlockEntityRenderer
implements CustomBlockEntityRenderer<EntangledBlockEntity> {
    private static int depth = 0;

    public void render(EntangledBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        VoxelShape shape;
        if (!entity.isBound()) {
            return;
        }
        BlockEntity boundTile = entity.m_58904_().m_46472_() == entity.getBoundDimensionIdentifier() ? entity.m_58904_().m_7702_(entity.getBoundBlockPos()) : null;
        BlockState boundState = entity.getBoundBlockState();
        boolean renderTile = boundTile != null && EntangledBlockEntityRenderer.canRenderTileEntity(Registries.BLOCK_ENTITY_TYPES.getIdentifier((Object)boundTile.m_58903_()));
        boolean renderBlock = boundState != null && boundState.m_60799_() == RenderShape.MODEL && EntangledBlockEntityRenderer.canRenderBlock(Registries.BLOCKS.getIdentifier((Object)boundState.m_60734_()));
        AABB bounds = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (renderBlock && entity.m_58904_().m_46472_() == entity.getBoundDimensionIdentifier() && !(shape = boundState.m_60768_((BlockGetter)entity.m_58904_(), entity.getBoundBlockPos())).m_83281_()) {
            bounds = shape.m_83215_();
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        if (EntangledConfig.rotateRenderedBlock.get().booleanValue()) {
            float angleX = (float)(System.currentTimeMillis() % 10000L) / 10000.0f * 360.0f;
            float angleY = (float)(System.currentTimeMillis() % 11000L) / 11000.0f * 360.0f;
            float angleZ = (float)(System.currentTimeMillis() % 12000L) / 12000.0f * 360.0f;
            poseStack.m_85845_(new Quaternion(angleX, angleY, angleZ, true));
        }
        float scale = 0.4763f / (float)Math.sqrt((bounds.m_82362_() * bounds.m_82362_() + bounds.m_82376_() * bounds.m_82376_() + bounds.m_82385_() * bounds.m_82385_()) / 4.0);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(-bounds.m_82399_().f_82479_, -bounds.m_82399_().f_82480_, -bounds.m_82399_().f_82481_);
        if (renderTile && (!(boundTile instanceof EntangledBlockEntity) || depth < 10)) {
            ++depth;
            ClientUtils.getMinecraft().m_167982_().m_112267_(boundTile, partialTicks, poseStack, bufferSource);
            --depth;
        }
        if (renderBlock) {
            ClientUtils.getBlockRenderer().m_110912_(boundState, poseStack, bufferSource, combinedLight, combinedOverlay);
        }
        poseStack.m_85849_();
    }

    private static boolean canRenderBlock(ResourceLocation block) {
        return !Entangled.RENDER_BLACKLISTED_MODS.contains(block.m_135827_()) && !Entangled.RENDER_BLACKLISTED_BLOCKS.contains(block);
    }

    private static boolean canRenderTileEntity(ResourceLocation tile) {
        return !Entangled.RENDER_BLACKLISTED_MODS.contains(tile.m_135827_()) && !Entangled.RENDER_BLACKLISTED_TILE_ENTITIES.contains(tile);
    }
}

