/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.reward;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Rewards {
    public static List<ContributorStarby> starbuncles = new ArrayList<ContributorStarby>();
    public static List<UUID> CONTRIBUTORS = new ArrayList<UUID>();

    public static void init() {
        try {
            JsonObject object = JsonParser.parseString((String)Rewards.readUrl(new URL("https://raw.githubusercontent.com/baileyholl/Ars-Nouveau/main/supporters.json"))).getAsJsonObject();
            JsonArray supporters = object.getAsJsonArray("uuids");
            for (JsonElement element : supporters) {
                String uuid = element.getAsString();
                CONTRIBUTORS.add(UUID.fromString(uuid));
            }
            JsonArray adoptions = object.getAsJsonArray("starbuncleAdoptions");
            for (JsonElement element : adoptions) {
                JsonObject jsonObject = element.getAsJsonObject();
                String name = jsonObject.get("name").getAsString();
                String adopter = jsonObject.get("adopter").getAsString();
                String color = jsonObject.get("color").getAsString();
                String bio = jsonObject.get("bio").getAsString();
                starbuncles.add(new ContributorStarby(name, adopter, color, bio));
            }
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrl(URL url) throws IOException {
        try (BufferedReader reader = null;){
            String var5;
            int read;
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer buffer = new StringBuffer();
            char[] chars = new char[1024];
            while ((read = reader.read(chars)) != -1) {
                buffer.append(chars, 0, read);
            }
            String string = var5 = buffer.toString();
            return string;
        }
    }

    public static class ContributorStarby {
        public String name;
        public String adopter;
        public String color;
        public String bio;

        public ContributorStarby(String name, String adopter, String color, String bio) {
            this.name = name;
            this.adopter = adopter;
            this.color = color;
            this.bio = bio;
        }
    }
}

