/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world.structure;

import com.hollingsworth.arsnouveau.setup.StructureRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class WildenDen
extends Structure {
    public static final Codec<WildenDen> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WildenDen.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, WildenDen::new)).codec();
    public final Holder<StructureTemplatePool> startPool;
    public final Optional<ResourceLocation> startJigsawName;
    public final int size;
    public final HeightProvider startHeight;
    public final Optional<Heightmap.Types> projectStartToHeightmap;
    public final int maxDistanceFromCenter;
    public Optional<Integer> terrainHeightCheckRadius = Optional.empty();
    public Optional<Integer> allowedTerrainHeightRange = Optional.empty();
    public boolean cannotSpawnInLiquid = true;
    public Optional<Integer> minYAllowed = Optional.empty();
    public Optional<Integer> maxYAllowed = Optional.empty();

    public WildenDen(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.terrainHeightCheckRadius = Optional.of(1);
        this.allowedTerrainHeightRange = Optional.of(6);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        if (this.cannotSpawnInLiquid) {
            BlockPos centerOfChunk = context.f_226628_().m_151394_(0);
            int landHeight = context.f_226622_().m_223235_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
            NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_226629_(), context.f_226624_());
            BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return Optional.empty();
            }
        }
        if (this.terrainHeightCheckRadius.isPresent() && (this.allowedTerrainHeightRange.isPresent() || this.minYAllowed.isPresent())) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            int terrainCheckRange = this.terrainHeightCheckRadius.get();
            for (int curChunkX = chunkPos.f_45578_ - terrainCheckRange; curChunkX <= chunkPos.f_45578_ + terrainCheckRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - terrainCheckRange; curChunkZ <= chunkPos.f_45579_ + terrainCheckRange; ++curChunkZ) {
                    int height = context.f_226622_().m_214096_((curChunkX << 4) + 7, (curChunkZ << 4) + 7, this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG), context.f_226629_(), context.f_226624_());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                    if (this.minYAllowed.isPresent() && minTerrainHeight < this.minYAllowed.get()) {
                        return Optional.empty();
                    }
                    if (!this.maxYAllowed.isPresent() || minTerrainHeight <= this.maxYAllowed.get()) continue;
                    return Optional.empty();
                }
            }
            if (this.allowedTerrainHeightRange.isPresent() && maxTerrainHeight - minTerrainHeight > this.allowedTerrainHeightRange.get()) {
                return Optional.empty();
            }
        }
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public void m_214110_(WorldGenLevel level, StructureManager manager, ChunkGenerator p_226562_, RandomSource p_226563_, BoundingBox p_226564_, ChunkPos p_226565_, PiecesContainer p_226566_) {
        super.m_214110_(level, manager, p_226562_, p_226563_, p_226564_, p_226565_, p_226566_);
        BlockPos.m_121976_((int)p_226564_.m_162395_(), (int)p_226564_.m_162396_(), (int)p_226564_.m_162398_(), (int)p_226564_.m_162399_(), (int)p_226564_.m_162400_(), (int)p_226564_.m_162401_()).forEach(pos -> {
            if (level.m_8055_(pos).m_60713_(Blocks.f_152539_) && level.m_8055_(pos).m_61138_((Property)CaveVinesPlantBlock.f_152949_) && ((Boolean)level.m_8055_(pos).m_61143_((Property)CaveVinesPlantBlock.f_152949_)).booleanValue()) {
                level.m_7731_(pos, (BlockState)Blocks.f_152539_.m_49966_().m_61124_((Property)CaveVinesPlantBlock.f_152949_, (Comparable)Boolean.valueOf(false)), 2);
            }
            if (level.m_8055_(pos).m_60713_(Blocks.f_152538_)) {
                level.m_7731_(pos, (BlockState)((BlockState)Blocks.f_152538_.m_49966_().m_61124_((Property)CaveVinesPlantBlock.f_152949_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(25)), 2);
            }
        });
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructureRegistry.WILDEN_DEN.get();
    }
}

