/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class EffectInteract
extends AbstractEffect {
    public static EffectInteract INSTANCE = new EffectInteract();

    private EffectInteract() {
        super(GlyphLib.EffectInteractID, "Interact");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity e = rayTraceResult.m_82443_();
        Player player = this.getPlayer(shooter, (ServerLevel)world);
        if (!this.isRealPlayer((Entity)shooter)) {
            InventoryManager manager = spellContext.getCaster().getInvManager();
            player = this.setupFakeInventory(spellContext, world);
            this.useOnEntity(player, spellStats, e);
            for (ItemStack i : player.f_36093_.f_35974_) {
                manager.insertOrDrop(i, world, e.m_20183_());
            }
        } else {
            this.useOnEntity(player, spellStats, e);
        }
    }

    public InteractionHand getHand(Player player) {
        return player instanceof ANFakePlayer ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public boolean handleBucket(ItemStack item, BucketItem bucket, Player player, BlockState state, Level world, BlockPos pos, BlockHitResult rayTraceResult) {
        if (bucket.getFluid() == Fluids.f_76191_) {
            BlockPos target;
            boolean isBucketPickup = state.m_60734_() instanceof BucketPickup && world.m_6425_(pos) != Fluids.f_76191_.m_76145_();
            BlockPos blockPos = target = isBucketPickup ? pos : pos.m_121945_(rayTraceResult.m_82434_());
            if (world.m_6425_(target) == Fluids.f_76191_.m_76145_()) {
                return false;
            }
            BlockState targetState = world.m_8055_(target);
            Block block = targetState.m_60734_();
            if (block instanceof BucketPickup) {
                BucketPickup bp = (BucketPickup)block;
                ItemStack pickup = bp.m_142598_((LevelAccessor)world, target, targetState);
                if (!pickup.m_41619_() && !player.m_150110_().f_35937_) {
                    bp.getPickupSound(targetState).ifPresent(sound -> player.m_5496_(sound, 1.0f, 1.0f));
                    world.m_142346_((Entity)player, GameEvent.f_157816_, target);
                    ItemStack result = ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)pickup);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.f_10576_.m_38772_(serverPlayer, item);
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)bucket));
                    player.m_21008_(InteractionHand.OFF_HAND, result);
                }
                return !pickup.m_41619_();
            }
        } else {
            boolean placed = bucket.m_142073_(player, world, pos, rayTraceResult);
            if (placed) {
                if (!player.m_150110_().f_35937_) {
                    player.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42446_));
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10591_.m_59469_(serverPlayer, pos, item);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)bucket));
            }
            return placed;
        }
        return false;
    }

    public void useOnEntity(Player player, SpellStats spellStats, Entity target) {
        if (spellStats.isSensitive()) {
            ItemStack item = player.m_21120_(this.getHand(player));
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                InteractionResult res = item.m_41647_(player, livingEntity, this.getHand(player));
                if (res != InteractionResult.SUCCESS) {
                    target.m_6096_(player, this.getHand(player));
                }
            } else {
                target.m_6096_(player, this.getHand(player));
            }
        } else {
            player.m_36157_(target, InteractionHand.MAIN_HAND);
        }
    }

    public void useOnBlock(Player player, SpellStats spellStats, BlockPos pos, BlockState state, Level world, BlockHitResult rayTraceResult) {
        if (spellStats.isSensitive()) {
            ItemStack item = player.m_21120_(this.getHand(player));
            Item item2 = item.m_41720_();
            if (item2 instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item2;
                this.handleBucket(item, bucket, player, state, world, pos, rayTraceResult);
                return;
            }
            UseOnContext context = new UseOnContext(player, this.getHand(player), rayTraceResult);
            item.m_41661_(context);
        } else {
            state.m_60664_(world, player, InteractionHand.MAIN_HAND, rayTraceResult);
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos blockPos = rayTraceResult.m_82425_();
        BlockState blockState = world.m_8055_(blockPos);
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, blockPos)) {
            return;
        }
        Player player = this.getPlayer(shooter, (ServerLevel)world);
        if (this.isRealPlayer((Entity)shooter)) {
            this.useOnBlock(player, spellStats, blockPos, blockState, world, rayTraceResult);
        } else {
            InventoryManager manager = spellContext.getCaster().getInvManager();
            player = this.setupFakeInventory(spellContext, world);
            this.useOnBlock(player, spellStats, blockPos, blockState, world, rayTraceResult);
            for (ItemStack i : player.f_36093_.f_35974_) {
                manager.insertOrDrop(i, world, rayTraceResult.m_82425_());
            }
        }
    }

    public FakePlayer setupFakeInventory(SpellContext context, Level level) {
        InventoryManager manager = context.getCaster().getInvManager();
        ANFakePlayer player = ANFakePlayer.getPlayer((ServerLevel)level);
        player.f_36093_.m_6211_();
        player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        player.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        ExtractedStack stack = manager.extractItem(i -> !i.m_41619_(), 1);
        if (!stack.isEmpty()) {
            player.m_8061_(EquipmentSlot.MAINHAND, stack.getStack().m_41777_());
        }
        return player;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentSensitive.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Interacts with blocks or entities as it were a player. Useful for reaching levers, chests, or animals. Sensitive will use your off-hand item on the block or entity.";
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

