/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.container.CraftingTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.common.block.tile.StorageLecternTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.PlayState;
import software.bernie.ars_nouveau.geckolib3.core.builder.AnimationBuilder;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;
import software.bernie.ars_nouveau.geckolib3.util.GeckoLibUtil;

public class CraftingLecternTile
extends StorageLecternTile
implements IAnimatable {
    private AbstractContainerMenu craftingContainer = new AbstractContainerMenu(MenuType.f_39968_, 0){

        public boolean m_6875_(Player player) {
            return false;
        }

        public void m_6199_(Container inventory) {
            if (CraftingLecternTile.this.f_58857_ != null && !((CraftingLecternTile)CraftingLecternTile.this).f_58857_.f_46443_) {
                CraftingLecternTile.this.onCraftingMatrixChanged();
            }
        }

        public ItemStack m_7648_(Player p_38941_, int p_38942_) {
            return ItemStack.f_41583_;
        }
    };
    private CraftingRecipe currentRecipe;
    private final CraftingContainer craftMatrix = new CraftingContainer(this.craftingContainer, 3, 3);
    private ResultContainer craftResult = new ResultContainer();
    private HashSet<CraftingTerminalMenu> craftingListeners = new HashSet();
    private boolean reading;
    AnimationFactory animationFactory = GeckoLibUtil.createFactory(this);

    public CraftingLecternTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.CRAFTING_LECTERN_TILE.get(), pos, state);
    }

    @Override
    public AbstractContainerMenu m_7208_(int id, Inventory plInv, Player arg2) {
        return new CraftingTerminalMenu(id, plInv, this);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            ItemStack itemstack = this.craftMatrix.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128405_("Slot", i);
            itemstack.m_41739_(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.m_128365_("CraftingTable", (Tag)listnbt);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.reading = true;
        ListTag listnbt = compound.m_128437_("CraftingTable", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            int j = compoundnbt.m_128451_("Slot");
            if (j < 0 || j >= this.craftMatrix.m_6643_()) continue;
            this.craftMatrix.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
        this.reading = false;
    }

    public CraftingContainer getCraftingInv() {
        return this.craftMatrix;
    }

    public ResultContainer getCraftResult() {
        return this.craftResult;
    }

    public void craftShift(Player player, @Nullable String tab) {
        ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
        int amountCrafted = 0;
        ItemStack crafted = this.craftResult.m_8020_(0);
        do {
            this.craft(player, tab);
            craftedItemsList.add(crafted.m_41777_());
        } while (ItemStack.m_41746_((ItemStack)crafted, (ItemStack)this.craftResult.m_8020_(0)) && (amountCrafted += crafted.m_41613_()) + crafted.m_41613_() <= crafted.m_41741_());
        for (ItemStack craftedItem : craftedItemsList) {
            ItemStack is;
            if (player.m_150109_().m_36054_(craftedItem.m_41777_()) || (is = this.pushStack(craftedItem, tab)).m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)is);
        }
        crafted.m_41678_(player.f_19853_, player, amountCrafted);
        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)crafted, (int)amountCrafted), (Container)this.craftMatrix);
    }

    public void craft(Player thePlayer, @Nullable String tab) {
        if (this.currentRecipe != null) {
            NonNullList remainder = this.currentRecipe.m_7457_((Container)this.craftMatrix);
            boolean playerInvUpdate = false;
            for (int i = 0; i < remainder.size(); ++i) {
                ItemStack slot = this.craftMatrix.m_8020_(i);
                ItemStack oldItem = slot.m_41777_();
                ItemStack rem = (ItemStack)remainder.get(i);
                if (!slot.m_41619_()) {
                    this.craftMatrix.m_7407_(i, 1);
                    slot = this.craftMatrix.m_8020_(i);
                }
                if (slot.m_41619_() && !oldItem.m_41619_()) {
                    StoredItemStack is = this.pullStack(new StoredItemStack(oldItem), 1, tab);
                    if (is == null) {
                        for (int j = 0; j < thePlayer.m_150109_().m_6643_(); ++j) {
                            ItemStack st = thePlayer.m_150109_().m_8020_(j);
                            if (!ItemStack.m_41746_((ItemStack)oldItem, (ItemStack)st) || !ItemStack.m_41658_((ItemStack)oldItem, (ItemStack)st) || (st = thePlayer.m_150109_().m_7407_(j, 1)).m_41619_()) continue;
                            is = new StoredItemStack(st, 1L);
                            playerInvUpdate = true;
                            break;
                        }
                    }
                    if (is != null) {
                        this.craftMatrix.m_6836_(i, is.getActualStack());
                        slot = this.craftMatrix.m_8020_(i);
                    }
                }
                if (rem.m_41619_()) continue;
                if (slot.m_41619_()) {
                    this.craftMatrix.m_6836_(i, rem);
                    continue;
                }
                if (ItemStack.m_41746_((ItemStack)slot, (ItemStack)rem) && ItemStack.m_41658_((ItemStack)slot, (ItemStack)rem)) {
                    rem.m_41769_(slot.m_41613_());
                    this.craftMatrix.m_6836_(i, rem);
                    continue;
                }
                if ((rem = this.pushStack(rem, tab)).m_41619_() || thePlayer.m_150109_().m_36054_(rem)) continue;
                thePlayer.m_36176_(rem, false);
            }
            if (playerInvUpdate) {
                thePlayer.f_36096_.m_38946_();
            }
            this.onCraftingMatrixChanged();
        }
    }

    public void unregisterCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.remove(containerCraftingTerminal);
    }

    public void registerCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.add(containerCraftingTerminal);
    }

    protected void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.m_5818_((Container)this.craftMatrix, this.f_58857_)) {
            this.currentRecipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftMatrix, this.f_58857_).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.craftResult.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.craftResult.m_6836_(0, this.currentRecipe.m_5874_((Container)this.craftMatrix));
        }
        this.craftingListeners.forEach(CraftingTerminalMenu::onCraftMatrixChanged);
        if (!this.reading) {
            this.m_6596_();
        }
    }

    public void clear(@Nullable String tab) {
        for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            ItemStack st = this.craftMatrix.m_8016_(i);
            if (st.m_41619_()) continue;
            this.pushOrDrop(st, tab);
        }
        this.onCraftingMatrixChanged();
    }

    public void handlerItemTransfer(Player player, ItemStack[][] items, @Nullable String tab) {
        this.clear(tab);
        for (int i = 0; i < 9; ++i) {
            int j;
            if (items[i] == null) continue;
            ItemStack stack = ItemStack.f_41583_;
            for (j = 0; j < items[i].length; ++j) {
                ItemStack pulled = this.pullStack(items[i][j], tab);
                if (pulled.m_41619_()) continue;
                stack = pulled;
                break;
            }
            if (stack.m_41619_()) {
                for (j = 0; j < items[i].length; ++j) {
                    boolean br = false;
                    for (int k = 0; k < player.m_150109_().m_6643_(); ++k) {
                        if (!ItemStack.m_41746_((ItemStack)player.m_150109_().m_8020_(k), (ItemStack)items[i][j])) continue;
                        stack = player.m_150109_().m_7407_(k, 1);
                        br = true;
                        break;
                    }
                    if (br) break;
                }
            }
            if (stack.m_41619_()) continue;
            this.craftMatrix.m_6836_(i, stack);
        }
        this.onCraftingMatrixChanged();
    }

    private ItemStack pullStack(ItemStack itemStack, @Nullable String tab) {
        StoredItemStack is = this.pullStack(new StoredItemStack(itemStack), 1, tab);
        if (is == null) {
            return ItemStack.f_41583_;
        }
        return is.getActualStack();
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController<CraftingLecternTile>(this, "controller", 1.0f, event -> {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ledger_float"));
            return PlayState.CONTINUE;
        }));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.animationFactory;
    }
}

