/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.setup.Config;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class SkyTextureHandler {
    @SubscribeEvent
    public static void renderSky(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SKY)) {
            if (ArsNouveau.optifineLoaded || ((Boolean)Config.DISABLE_SKY_SHADER.get()).booleanValue()) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (ClientInfo.skyRenderTarget == null) {
                Window window = minecraft.m_91268_();
                SkyTextureHandler.setupRenderTarget(window.m_85441_(), window.m_85442_());
            }
            PoseStack poseStack = event.getPoseStack();
            GameRenderer gameRenderer = minecraft.f_91063_;
            LevelRenderer levelRenderer = minecraft.f_91060_;
            Camera camera = gameRenderer.m_109153_();
            Vec3 cameraPosition = camera.m_90583_();
            Matrix4f projectionMatrix = event.getProjectionMatrix();
            float partialTick = event.getPartialTick();
            boolean isFoggy = minecraft.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)cameraPosition.f_82479_), Mth.m_14107_((double)cameraPosition.f_82480_)) || minecraft.f_91065_.m_93090_().m_93715_();
            ClientInfo.skyRenderTarget.m_83947_(true);
            RenderSystem.m_69421_((int)16640, (boolean)Minecraft.f_91002_);
            FogRenderer.m_109018_((Camera)camera, (float)partialTick, (ClientLevel)minecraft.f_91073_, (int)minecraft.f_91066_.m_193772_(), (float)gameRenderer.m_109131_(partialTick));
            FogRenderer.m_109036_();
            RenderSystem.m_157427_(GameRenderer::m_172808_);
            levelRenderer.m_202423_(poseStack, projectionMatrix, partialTick, camera, isFoggy, () -> FogRenderer.m_234172_((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)gameRenderer.m_109152_(), (boolean)isFoggy, (float)partialTick));
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_166854_(poseStack.m_85850_().m_85861_());
            RenderSystem.m_157182_();
            if (minecraft.f_91066_.m_92174_() != CloudStatus.OFF) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                levelRenderer.m_172954_(poseStack, projectionMatrix, partialTick, cameraPosition.f_82479_, cameraPosition.f_82480_, cameraPosition.f_82481_);
            }
            RenderSystem.m_69458_((boolean)false);
            levelRenderer.m_109703_(gameRenderer.m_109154_(), partialTick, cameraPosition.f_82479_, cameraPosition.f_82480_, cameraPosition.f_82481_);
            RenderSystem.m_69458_((boolean)true);
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
            minecraft.m_91385_().m_83947_(true);
        }
    }

    public static void setupRenderTarget(int width, int height) {
        Minecraft instance = Minecraft.m_91087_();
        ClientInfo.skyRenderTarget = new TextureTarget(width, height, true, Minecraft.f_91002_);
    }
}

