/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.util;

import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerExtensionTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class ConnectedDrawers
implements INBTSerializable<CompoundTag> {
    private StorageControllerTile controllerTile;
    private List<Long> connectedDrawers;
    private List<IItemHandler> itemHandlers;
    private List<IFluidHandler> fluidHandlers;
    private Level level;
    private int extensions;

    public ConnectedDrawers(Level level, StorageControllerTile controllerTile) {
        this.controllerTile = controllerTile;
        this.connectedDrawers = new ArrayList<Long>();
        this.itemHandlers = new ArrayList<IItemHandler>();
        this.fluidHandlers = new ArrayList<IFluidHandler>();
        this.level = level;
        this.extensions = 0;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void rebuild() {
        this.itemHandlers = new ArrayList<IItemHandler>();
        this.fluidHandlers = new ArrayList<IFluidHandler>();
        this.extensions = 0;
        if (this.level != null && !this.level.m_5776_()) {
            for (Long connectedDrawer : this.connectedDrawers) {
                BlockPos pos = BlockPos.m_122022_((long)connectedDrawer);
                BlockEntity entity = this.level.m_7702_(pos);
                if (entity instanceof StorageControllerTile) continue;
                if (entity instanceof StorageControllerExtensionTile) {
                    ++this.extensions;
                    continue;
                }
                if (entity instanceof ItemControllableDrawerTile) {
                    ItemControllableDrawerTile itemControllableDrawerTile = (ItemControllableDrawerTile)entity;
                    this.itemHandlers.add(itemControllableDrawerTile.getStorage());
                }
                if (!(entity instanceof FluidDrawerTile)) continue;
                FluidDrawerTile fluidDrawerTile = (FluidDrawerTile)entity;
                this.fluidHandlers.add(fluidDrawerTile.getFluidHandler());
            }
        }
        this.controllerTile.inventoryHandler.invalidateSlots();
        this.controllerTile.fluidHandler.invalidateSlots();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        for (int i = 0; i < this.connectedDrawers.size(); ++i) {
            compoundTag.m_128356_("" + i, this.connectedDrawers.get(i).longValue());
        }
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.connectedDrawers = new ArrayList<Long>();
        for (String allKey : nbt.m_128431_()) {
            this.connectedDrawers.add(nbt.m_128454_(allKey));
        }
        this.rebuild();
    }

    public List<Long> getConnectedDrawers() {
        return this.connectedDrawers;
    }

    public List<IItemHandler> getItemHandlers() {
        return this.itemHandlers;
    }

    public List<IFluidHandler> getFluidHandlers() {
        return this.fluidHandlers;
    }

    public int getExtensions() {
        return this.extensions;
    }
}

