/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.hrznstudio.titanium.item.BasicItem;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class UpgradeItem
extends BasicItem {
    public static int MAX_SLOT = 4;
    private final Type type;

    public static Direction getDirection(ItemStack stack) {
        Item item;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Direction") && ((item = stack.m_41720_()).equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get()))) {
            Direction direction = Direction.m_122402_((String)stack.m_41784_().m_128461_("Direction"));
            return direction == null ? Direction.NORTH : direction;
        }
        return Direction.NORTH;
    }

    public UpgradeItem(Item.Properties properties, Type type) {
        super(properties.m_41491_((CreativeModeTab)FunctionalStorage.TAB));
        this.type = type;
    }

    public void m_7836_(ItemStack p_41447_, Level p_41448_, Player p_41449_) {
        super.m_7836_(p_41447_, p_41448_, p_41449_);
        this.initNbt(p_41447_);
    }

    private ItemStack initNbt(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item.equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) {
            stack.m_41784_().m_128359_("Direction", Direction.values()[0].m_122433_());
        }
        if (item.equals(FunctionalStorage.REDSTONE_UPGRADE.get())) {
            stack.m_41784_().m_128405_("Slot", 0);
        }
        return stack;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)this.initNbt(new ItemStack((ItemLike)this)));
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean m_142305_(ItemStack first, ItemStack second, Slot p_150894_, ClickAction clickAction, Player p_150896_, SlotAccess p_150897_) {
        if (clickAction == ClickAction.SECONDARY && first.m_41613_() == 1) {
            Item item = first.m_41720_();
            if (item.equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) {
                Direction direction = UpgradeItem.getDirection(first);
                Direction next = Direction.values()[(Arrays.asList(Direction.values()).indexOf(direction) + 1) % Direction.values().length];
                first.m_41784_().m_128359_("Direction", next.m_122433_());
                p_150896_.m_5496_(SoundEvents.f_12490_, 0.5f, 1.0f);
                return true;
            }
            if (item.equals(FunctionalStorage.REDSTONE_UPGRADE.get())) {
                int slot = first.m_41784_().m_128451_("Slot");
                first.m_41784_().m_128405_("Slot", (slot + 1) % MAX_SLOT);
                p_150896_.m_5496_(SoundEvents.f_12490_, 0.5f, 1.0f);
                return true;
            }
        }
        return super.m_142305_(first, second, p_150894_, clickAction, p_150896_, p_150897_);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        tooltip.add((Component)Component.m_237115_((String)"upgrade.type").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237115_((String)("upgrade.type." + this.getType().name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.WHITE)));
        Item item = stack.m_41720_();
        if (stack.m_41782_()) {
            if (item.equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) {
                tooltip.add((Component)Component.m_237115_((String)"item.utility.direction").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237115_((String)WordUtils.capitalize((String)UpgradeItem.getDirection(stack).m_122433_().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.WHITE)));
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"item.utility.direction.desc").m_130940_(ChatFormatting.GRAY));
            }
            if (item.equals(FunctionalStorage.REDSTONE_UPGRADE.get())) {
                tooltip.add((Component)Component.m_237115_((String)"item.utility.slot").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)("" + stack.m_41784_().m_128451_("Slot"))).m_130940_(ChatFormatting.WHITE)));
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"item.utility.direction.desc").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public static enum Type {
        STORAGE,
        UTILITY;

    }
}

