/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage;

import com.buuz135.functionalstorage.block.ArmoryCabinetBlock;
import com.buuz135.functionalstorage.block.CompactingDrawerBlock;
import com.buuz135.functionalstorage.block.CompactingFramedDrawerBlock;
import com.buuz135.functionalstorage.block.ControllerExtensionBlock;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.DrawerControllerBlock;
import com.buuz135.functionalstorage.block.EnderDrawerBlock;
import com.buuz135.functionalstorage.block.FluidDrawerBlock;
import com.buuz135.functionalstorage.block.FramedControllerExtensionBlock;
import com.buuz135.functionalstorage.block.FramedDrawerBlock;
import com.buuz135.functionalstorage.block.FramedDrawerControllerBlock;
import com.buuz135.functionalstorage.block.SimpleCompactingDrawerBlock;
import com.buuz135.functionalstorage.block.tile.CompactingFramedDrawerTile;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.block.tile.FramedDrawerTile;
import com.buuz135.functionalstorage.block.tile.SimpleCompactingDrawerTile;
import com.buuz135.functionalstorage.client.CompactingDrawerRenderer;
import com.buuz135.functionalstorage.client.ControllerRenderer;
import com.buuz135.functionalstorage.client.DrawerRenderer;
import com.buuz135.functionalstorage.client.EnderDrawerRenderer;
import com.buuz135.functionalstorage.client.FluidDrawerRenderer;
import com.buuz135.functionalstorage.client.SimpleCompactingDrawerRenderer;
import com.buuz135.functionalstorage.client.loader.FramedModel;
import com.buuz135.functionalstorage.data.FunctionalStorageBlockTagsProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageBlockstateProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageItemTagsProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageLangProvider;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.inventory.item.DrawerStackItemHandler;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.network.EnderDrawerSyncMessage;
import com.buuz135.functionalstorage.recipe.DrawerlessWoodIngredient;
import com.buuz135.functionalstorage.recipe.FramedDrawerRecipe;
import com.buuz135.functionalstorage.util.DrawerWoodType;
import com.buuz135.functionalstorage.util.IWoodType;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.buuz135.functionalstorage.util.StorageTags;
import com.buuz135.functionalstorage.util.TooltipUtil;
import com.google.common.base.Supplier;
import com.hrznstudio.titanium.block.BasicBlock;
import com.hrznstudio.titanium.datagenerator.loot.TitaniumLootTableProvider;
import com.hrznstudio.titanium.datagenerator.model.BlockItemModelGeneratorProvider;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.recipe.generator.TitaniumRecipeProvider;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.AdvancedTitaniumTab;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="functionalstorage")
public class FunctionalStorage
extends ModuleController {
    public static final String MOD_ID = "functionalstorage";
    public static NetworkHandler NETWORK = new NetworkHandler("functionalstorage");
    public static final Logger LOGGER;
    public static List<IWoodType> WOOD_TYPES;
    public static HashMap<DrawerType, List<Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>>>> DRAWER_TYPES;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> COMPACTING_DRAWER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> DRAWER_CONTROLLER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> ARMORY_CABINET;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> ENDER_DRAWER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> FRAMED_COMPACTING_DRAWER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> FLUID_DRAWER_1;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> FLUID_DRAWER_2;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> FLUID_DRAWER_4;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> CONTROLLER_EXTENSION;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> SIMPLE_COMPACTING_DRAWER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> FRAMED_DRAWER_CONTROLLER;
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> FRAMED_CONTROLLER_EXTENSION;
    public static RegistryObject<Item> LINKING_TOOL;
    public static HashMap<StorageUpgradeItem.StorageTier, RegistryObject<Item>> STORAGE_UPGRADES;
    public static RegistryObject<Item> COLLECTOR_UPGRADE;
    public static RegistryObject<Item> PULLING_UPGRADE;
    public static RegistryObject<Item> PUSHING_UPGRADE;
    public static RegistryObject<Item> VOID_UPGRADE;
    public static RegistryObject<Item> CONFIGURATION_TOOL;
    public static RegistryObject<Item> REDSTONE_UPGRADE;
    public static RegistryObject<Item> CREATIVE_UPGRADE;
    public static AdvancedTitaniumTab TAB;

    public FunctionalStorage() {
        ForgeMod.enableMilkFluid();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::onClient);
        EventManager.forge(BlockEvent.BreakEvent.class).process(breakEvent -> {
            if (breakEvent.getPlayer().m_7500_()) {
                int hit;
                if (breakEvent.getState().m_60734_() instanceof DrawerBlock && (hit = ((DrawerBlock)breakEvent.getState().m_60734_()).getHit(breakEvent.getState(), breakEvent.getPlayer().m_9236_(), breakEvent.getPos(), breakEvent.getPlayer())) != -1) {
                    breakEvent.setCanceled(true);
                    ((DrawerBlock)breakEvent.getState().m_60734_()).m_6256_(breakEvent.getState(), breakEvent.getPlayer().m_9236_(), breakEvent.getPos(), breakEvent.getPlayer());
                }
                if (breakEvent.getState().m_60734_() instanceof CompactingDrawerBlock && (hit = ((CompactingDrawerBlock)breakEvent.getState().m_60734_()).getHit(breakEvent.getState(), breakEvent.getPlayer().m_9236_(), breakEvent.getPos(), breakEvent.getPlayer())) != -1) {
                    breakEvent.setCanceled(true);
                    ((CompactingDrawerBlock)breakEvent.getState().m_60734_()).m_6256_(breakEvent.getState(), breakEvent.getPlayer().m_9236_(), breakEvent.getPos(), breakEvent.getPlayer());
                }
                if (breakEvent.getState().m_60734_() instanceof EnderDrawerBlock && (hit = ((EnderDrawerBlock)breakEvent.getState().m_60734_()).getHit(breakEvent.getState(), breakEvent.getPlayer().m_9236_(), breakEvent.getPos(), breakEvent.getPlayer())) != -1) {
                    breakEvent.setCanceled(true);
                    ((EnderDrawerBlock)breakEvent.getState().m_60734_()).m_6256_(breakEvent.getState(), breakEvent.getPlayer().m_9236_(), breakEvent.getPos(), breakEvent.getPlayer());
                }
                if (breakEvent.getState().m_60734_() instanceof FluidDrawerBlock && (hit = ((FluidDrawerBlock)breakEvent.getState().m_60734_()).getHit(breakEvent.getState(), breakEvent.getPlayer().m_9236_(), breakEvent.getPos(), breakEvent.getPlayer())) != -1) {
                    breakEvent.setCanceled(true);
                    ((FluidDrawerBlock)breakEvent.getState().m_60734_()).m_6256_(breakEvent.getState(), breakEvent.getPlayer().m_9236_(), breakEvent.getPos(), breakEvent.getPlayer());
                }
            }
        }).subscribe();
        EventManager.mod(FMLCommonSetupEvent.class).process(fmlCommonSetupEvent -> CraftingHelper.register((ResourceLocation)DrawerlessWoodIngredient.NAME, (IIngredientSerializer)DrawerlessWoodIngredient.SERIALIZER)).subscribe();
        NBTManager.getInstance().scanTileClassForAnnotations(FramedDrawerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(CompactingFramedDrawerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(FluidDrawerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(SimpleCompactingDrawerTile.class);
    }

    protected void initModules() {
        WOOD_TYPES.addAll(List.of(DrawerWoodType.values()));
        for (DrawerType drawerType2 : DrawerType.values()) {
            for (IWoodType woodType : WOOD_TYPES) {
                String name = woodType.getName() + "_" + drawerType2.getSlots();
                if (woodType == DrawerWoodType.FRAMED) {
                    Pair pair = this.getRegistries().registerBlockWithTileItem(name, () -> new FramedDrawerBlock(drawerType2), blockRegistryObject -> () -> new DrawerBlock.DrawerItem((DrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties().m_41491_((CreativeModeTab)TAB)));
                    DRAWER_TYPES.computeIfAbsent(drawerType2, drawerType -> new ArrayList()).add(pair);
                    CompactingFramedDrawerBlock.FRAMED.add((RegistryObject<Block>)((RegistryObject)pair.getLeft()));
                    continue;
                }
                DRAWER_TYPES.computeIfAbsent(drawerType2, drawerType -> new ArrayList()).add(this.getRegistries().registerBlockWithTileItem(name, () -> new DrawerBlock(woodType, drawerType2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)woodType.getPlanks())), blockRegistryObject -> () -> new DrawerBlock.DrawerItem((DrawerBlock)((Object)((Object)((Object)((Object)blockRegistryObject.get())))), new Item.Properties().m_41491_((CreativeModeTab)TAB))));
            }
            DRAWER_TYPES.get((Object)drawerType2).forEach(blockRegistryObject -> TAB.addIconStacks(new Supplier[]{() -> new ItemStack((ItemLike)((RegistryObject)blockRegistryObject.getLeft()).get())}));
        }
        COMPACTING_DRAWER = this.getRegistries().registerBlockWithTile("compacting_drawer", () -> new CompactingDrawerBlock("compacting_drawer", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_)));
        FRAMED_COMPACTING_DRAWER = this.getRegistries().registerBlockWithTile("compacting_framed_drawer", () -> new CompactingFramedDrawerBlock("compacting_framed_drawer"));
        FLUID_DRAWER_1 = this.getRegistries().registerBlockWithTile("fluid_1", () -> new FluidDrawerBlock(DrawerType.X_1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_)));
        FLUID_DRAWER_2 = this.getRegistries().registerBlockWithTile("fluid_2", () -> new FluidDrawerBlock(DrawerType.X_2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_)));
        FLUID_DRAWER_4 = this.getRegistries().registerBlockWithTile("fluid_4", () -> new FluidDrawerBlock(DrawerType.X_4, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_)));
        DRAWER_CONTROLLER = this.getRegistries().registerBlockWithTile("storage_controller", DrawerControllerBlock::new);
        CONTROLLER_EXTENSION = this.getRegistries().registerBlockWithTile("controller_extension", ControllerExtensionBlock::new);
        LINKING_TOOL = this.getRegistries().registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), "linking_tool", LinkingToolItem::new);
        for (Enum enum_ : StorageUpgradeItem.StorageTier.values()) {
            STORAGE_UPGRADES.put((StorageUpgradeItem.StorageTier)enum_, (RegistryObject<Item>)this.getRegistries().registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), enum_.name().toLowerCase(Locale.ROOT) + (enum_ == StorageUpgradeItem.StorageTier.IRON ? "_downgrade" : "_upgrade"), () -> FunctionalStorage.lambda$initModules$18((StorageUpgradeItem.StorageTier)enum_)));
        }
        SIMPLE_COMPACTING_DRAWER = this.getRegistries().registerBlockWithTile("simple_compacting_drawer", () -> new SimpleCompactingDrawerBlock("simple_compacting_drawer", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_)));
        COLLECTOR_UPGRADE = this.getRegistries().registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), "collector_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        PULLING_UPGRADE = this.getRegistries().registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), "puller_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        PUSHING_UPGRADE = this.getRegistries().registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), "pusher_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        VOID_UPGRADE = this.getRegistries().registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), "void_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        ARMORY_CABINET = this.getRegistries().registerBlockWithTile("armory_cabinet", ArmoryCabinetBlock::new);
        CONFIGURATION_TOOL = this.getRegistries().registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), "configuration_tool", ConfigurationToolItem::new);
        ENDER_DRAWER = this.getRegistries().registerBlockWithTile("ender_drawer", EnderDrawerBlock::new);
        REDSTONE_UPGRADE = this.getRegistries().registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), "redstone_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        CREATIVE_UPGRADE = this.getRegistries().registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), "creative_vending_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.STORAGE){

            public boolean m_5812_(ItemStack p_41453_) {
                return true;
            }
        });
        FRAMED_DRAWER_CONTROLLER = this.getRegistries().registerBlockWithTile("framed_storage_controller", FramedDrawerControllerBlock::new);
        FRAMED_CONTROLLER_EXTENSION = this.getRegistries().registerBlockWithTile("framed_controller_extension", FramedControllerExtensionBlock::new);
        this.getRegistries().registerGeneric(ForgeRegistries.RECIPE_SERIALIZERS.getRegistryKey(), "framed_recipe", () -> FramedDrawerRecipe.SERIALIZER);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClient() {
        EventManager.mod(EntityRenderersEvent.RegisterRenderers.class).process(registerRenderers -> {
            for (DrawerType value : DrawerType.values()) {
                DRAWER_TYPES.get((Object)value).forEach(blockRegistryObject -> registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)blockRegistryObject.getRight()).get(), p_173571_ -> new DrawerRenderer()));
            }
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)COMPACTING_DRAWER.getRight()).get(), p_173571_ -> new CompactingDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)FRAMED_COMPACTING_DRAWER.getRight()).get(), p_173571_ -> new CompactingDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)DRAWER_CONTROLLER.getRight()).get(), p -> new ControllerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)ENDER_DRAWER.getRight()).get(), p_173571_ -> new EnderDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)FLUID_DRAWER_1.getRight()).get(), p_173571_ -> new FluidDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)FLUID_DRAWER_2.getRight()).get(), p_173571_ -> new FluidDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)FLUID_DRAWER_4.getRight()).get(), p_173571_ -> new FluidDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)SIMPLE_COMPACTING_DRAWER.getRight()).get(), p_173571_ -> new SimpleCompactingDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer((BlockEntityType)((RegistryObject)FRAMED_DRAWER_CONTROLLER.getRight()).get(), p -> new ControllerRenderer());
        }).subscribe();
        EventManager.mod(RegisterColorHandlersEvent.Item.class).process(item -> {
            item.getItemColors().m_92689_((stack, tint) -> {
                CompoundTag tag = stack.m_41784_();
                LinkingToolItem.LinkingMode linkingMode = LinkingToolItem.getLinkingMode(stack);
                LinkingToolItem.ActionMode linkingAction = LinkingToolItem.getActionMode(stack);
                if (tint != 0 && stack.m_41784_().m_128441_("Ender")) {
                    return new Color(44, 150, 88).getRGB();
                }
                if (tint == 3 && tag.m_128441_("Controller")) {
                    return Color.RED.getRGB();
                }
                if (tint == 1) {
                    return linkingMode.getColor().m_131265_();
                }
                if (tint == 2) {
                    return linkingAction.getColor().m_131265_();
                }
                return 0xFFFFFF;
            }, new ItemLike[]{(ItemLike)LINKING_TOOL.get()});
            item.getItemColors().m_92689_((stack, tint) -> {
                ConfigurationToolItem.ConfigurationAction action = ConfigurationToolItem.getAction(stack);
                if (tint == 1) {
                    return action.getColor().m_131265_();
                }
                return 0xFFFFFF;
            }, new ItemLike[]{(ItemLike)CONFIGURATION_TOOL.get()});
        }).subscribe();
        EventManager.mod(FMLClientSetupEvent.class).process(event -> {
            for (DrawerType value : DrawerType.values()) {
                for (RegistryObject blockRegistryObject : DRAWER_TYPES.get((Object)value).stream().map(Pair::getLeft).collect(Collectors.toList())) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)blockRegistryObject.get()), (RenderType)RenderType.m_110463_());
                }
            }
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)COMPACTING_DRAWER.getLeft()).get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)FRAMED_COMPACTING_DRAWER.getLeft()).get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)ENDER_DRAWER.getLeft()).get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)FLUID_DRAWER_1.getLeft()).get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)FLUID_DRAWER_2.getLeft()).get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)FLUID_DRAWER_4.getLeft()).get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)SIMPLE_COMPACTING_DRAWER.getLeft()).get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)FRAMED_DRAWER_CONTROLLER.getLeft()).get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)FRAMED_CONTROLLER_EXTENSION.getLeft()).get()), (RenderType)RenderType.m_110463_());
        }).subscribe();
        EventManager.forge(RenderTooltipEvent.Pre.class).process(itemTooltipEvent -> {
            if (itemTooltipEvent.getItemStack().m_41720_().equals(((Block)((RegistryObject)ENDER_DRAWER.getLeft()).get()).m_5456_()) && itemTooltipEvent.getItemStack().m_41782_()) {
                TooltipUtil.renderItems(itemTooltipEvent.getPoseStack(), EnderDrawerBlock.getFrequencyDisplay(itemTooltipEvent.getItemStack().m_41783_().m_128469_("Tile").m_128461_("frequency")), itemTooltipEvent.getX() + 14, itemTooltipEvent.getY() + 11);
            }
            if (itemTooltipEvent.getItemStack().m_150930_((Item)LINKING_TOOL.get()) && itemTooltipEvent.getItemStack().m_41784_().m_128441_("Ender")) {
                TooltipUtil.renderItems(itemTooltipEvent.getPoseStack(), EnderDrawerBlock.getFrequencyDisplay(itemTooltipEvent.getItemStack().m_41784_().m_128461_("Ender")), itemTooltipEvent.getX() + 14, itemTooltipEvent.getY() + 11);
            }
            itemTooltipEvent.getItemStack().getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                if (iItemHandler instanceof DrawerStackItemHandler) {
                    int i = 0;
                    for (BigInventoryHandler.BigStack storedStack : ((DrawerStackItemHandler)iItemHandler).getStoredStacks()) {
                        TooltipUtil.renderItemAdvanced(itemTooltipEvent.getPoseStack(), storedStack.getStack(), itemTooltipEvent.getX() + 20 + 26 * i, itemTooltipEvent.getY() + 11, 512, NumberUtils.getFormatedBigNumber(storedStack.getAmount()) + "/" + NumberUtils.getFormatedBigNumber(iItemHandler.getSlotLimit(i)));
                        ++i;
                    }
                }
            });
        }).subscribe();
        EventManager.mod(ModelEvent.RegisterGeometryLoaders.class).process(modelRegistryEvent -> modelRegistryEvent.register("framedblock", (IGeometryLoader)FramedModel.Loader.INSTANCE)).subscribe();
    }

    public void addDataProvider(GatherDataEvent event) {
        final NonNullLazy blocksToProcess = NonNullLazy.of(() -> ForgeRegistries.BLOCKS.getValues().stream().filter(basicBlock -> Optional.ofNullable(ForgeRegistries.BLOCKS.getKey(basicBlock)).map(ResourceLocation::m_135827_).filter(MOD_ID::equalsIgnoreCase).isPresent()).collect(Collectors.toList()));
        event.getGenerator().m_236039_(true, (DataProvider)new BlockItemModelGeneratorProvider(event.getGenerator(), MOD_ID, blocksToProcess));
        event.getGenerator().m_236039_(true, (DataProvider)new FunctionalStorageBlockstateProvider(event.getGenerator(), event.getExistingFileHelper(), (NonNullLazy<List<Block>>)blocksToProcess));
        event.getGenerator().m_236039_(true, (DataProvider)new TitaniumLootTableProvider(event.getGenerator(), blocksToProcess));
        event.getGenerator().m_236039_(true, (DataProvider)new FunctionalStorageItemTagsProvider(event.getGenerator(), new BlockTagsProvider(event.getGenerator()), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().m_236039_(true, (DataProvider)new FunctionalStorageLangProvider(event.getGenerator(), MOD_ID, "en_us"));
        event.getGenerator().m_236039_(true, (DataProvider)new FunctionalStorageBlockTagsProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().m_236039_(true, (DataProvider)new ItemModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()){

            protected void registerModels() {
                ((List)blocksToProcess.get()).forEach(block -> this.withExistingParent(ForgeRegistries.BLOCKS.getKey(block).m_135815_(), new ResourceLocation(FunctionalStorage.MOD_ID, "block/" + ForgeRegistries.BLOCKS.getKey(block).m_135815_())));
                for (StorageUpgradeItem.StorageTier storageTier : STORAGE_UPGRADES.keySet()) {
                    this.item((Item)STORAGE_UPGRADES.get((Object)storageTier).get());
                }
                this.item((Item)COLLECTOR_UPGRADE.get());
                this.item((Item)PULLING_UPGRADE.get());
                this.item((Item)PUSHING_UPGRADE.get());
                this.item((Item)VOID_UPGRADE.get());
                this.item((Item)REDSTONE_UPGRADE.get());
                this.item((Item)CREATIVE_UPGRADE.get());
            }

            private void item(Item item) {
                this.singleTexture(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), new ResourceLocation("minecraft:item/generated"), "layer0", new ResourceLocation(FunctionalStorage.MOD_ID, "items/" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_()));
            }
        });
        event.getGenerator().m_236039_(true, (DataProvider)new BlockModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()){

            protected void registerModels() {
                for (DrawerType value : DrawerType.values()) {
                    for (RegistryObject blockRegistryObject : DRAWER_TYPES.get((Object)value).stream().map(Pair::getLeft).collect(Collectors.toList())) {
                        if (blockRegistryObject.get() instanceof FramedDrawerBlock) continue;
                        ((BlockModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_() + "_locked", this.modLoc(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
                    }
                }
                ((BlockModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)COMPACTING_DRAWER.getLeft()).get())).m_135815_() + "_locked", this.modLoc(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)COMPACTING_DRAWER.getLeft()).get())).m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
                ((BlockModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)ENDER_DRAWER.getLeft()).get())).m_135815_() + "_locked", this.modLoc(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)ENDER_DRAWER.getLeft()).get())).m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
                ((BlockModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)FLUID_DRAWER_1.getLeft()).get())).m_135815_() + "_locked", this.modLoc(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)FLUID_DRAWER_1.getLeft()).get())).m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
                ((BlockModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)FLUID_DRAWER_2.getLeft()).get())).m_135815_() + "_locked", this.modLoc(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)FLUID_DRAWER_2.getLeft()).get())).m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
                ((BlockModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)FLUID_DRAWER_4.getLeft()).get())).m_135815_() + "_locked", this.modLoc(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)FLUID_DRAWER_4.getLeft()).get())).m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
                ((BlockModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)SIMPLE_COMPACTING_DRAWER.getLeft()).get())).m_135815_() + "_locked", this.modLoc(ForgeRegistries.BLOCKS.getKey((Object)((Block)((RegistryObject)SIMPLE_COMPACTING_DRAWER.getLeft()).get())).m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
            }
        });
        event.getGenerator().m_236039_(true, (DataProvider)new TitaniumRecipeProvider(event.getGenerator()){

            public void register(Consumer<FinishedRecipe> consumer) {
                ((List)blocksToProcess.get()).stream().map(block -> (BasicBlock)block).forEach(basicBlock -> basicBlock.registerRecipe(consumer));
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())).m_126130_("III").m_126130_("IDI").m_126130_("III").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)VOID_UPGRADE.get())).m_126130_("III").m_126130_("IDI").m_126130_("III").m_206416_(Character.valueOf('I'), Tags.Items.OBSIDIAN).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)CONFIGURATION_TOOL.get())).m_126130_("PPG").m_126130_("PDG").m_126130_("PEP").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42616_).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)LINKING_TOOL.get())).m_126130_("PPG").m_126130_("PDG").m_126130_("PEP").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42415_).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.COPPER).get())).m_126130_("IBI").m_126130_("CDC").m_126130_("IBI").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_151052_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_151000_).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.GOLD).get())).m_126130_("IBI").m_126130_("CDC").m_126130_("BIB").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_GOLD).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('D'), (ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.COPPER).get()).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.DIAMOND).get())).m_126130_("IBI").m_126130_("CDC").m_126130_("IBI").m_206416_(Character.valueOf('I'), Tags.Items.GEMS_DIAMOND).m_206416_(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_DIAMOND).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('D'), (ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.GOLD).get()).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)REDSTONE_UPGRADE.get())).m_126130_("IBI").m_126130_("CDC").m_126130_("IBI").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42153_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42351_).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.DIAMOND).get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), (Item)((Item)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.NETHERITE).get())).m_126389_("has_netherite_ingot", (CriterionTriggerInstance)4.m_125977_((ItemLike)Items.f_42418_)).m_126395_(consumer, ForgeRegistries.ITEMS.getKey((Object)((Item)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.NETHERITE).get())));
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)((RegistryObject)ARMORY_CABINET.getLeft()).get())).m_126130_("ICI").m_126130_("CDC").m_126130_("IBI").m_206416_(Character.valueOf('I'), Tags.Items.STONE).m_206416_(Character.valueOf('B'), Tags.Items.INGOTS_NETHERITE).m_206416_(Character.valueOf('C'), StorageTags.DRAWER).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42351_).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)PULLING_UPGRADE.get())).m_126130_("ICI").m_126130_("IDI").m_126130_("IBI").m_206416_(Character.valueOf('I'), Tags.Items.STONE).m_206416_(Character.valueOf('B'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42155_).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)PUSHING_UPGRADE.get())).m_126130_("IBI").m_126130_("IDI").m_126130_("IRI").m_206416_(Character.valueOf('I'), Tags.Items.STONE).m_206416_(Character.valueOf('B'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42155_).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)COLLECTOR_UPGRADE.get())).m_126130_("IBI").m_126130_("RDR").m_126130_("IBI").m_206416_(Character.valueOf('I'), Tags.Items.STONE).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42155_).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)((RegistryObject)ENDER_DRAWER.getLeft()).get())).m_126130_("PPP").m_126130_("LCL").m_126130_("PPP").m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_ENDER).m_206416_(Character.valueOf('L'), StorageTags.DRAWER).m_176498_(consumer);
            }
        });
    }

    private static /* synthetic */ Item lambda$initModules$18(StorageUpgradeItem.StorageTier value) {
        return new StorageUpgradeItem(value);
    }

    static {
        NETWORK.registerMessage(EnderDrawerSyncMessage.class);
        LOGGER = LogManager.getLogger();
        WOOD_TYPES = new ArrayList<IWoodType>();
        DRAWER_TYPES = new HashMap();
        STORAGE_UPGRADES = new HashMap();
        TAB = new AdvancedTitaniumTab(MOD_ID, true);
    }

    public static enum DrawerType {
        X_1(1, 2048, "1x1", integer -> Pair.of((Object)16, (Object)16)),
        X_2(2, 1024, "1x2", integer -> {
            if (integer == 0) {
                return Pair.of((Object)16, (Object)28);
            }
            return Pair.of((Object)16, (Object)4);
        }),
        X_4(4, 512, "2x2", integer -> {
            if (integer == 0) {
                return Pair.of((Object)28, (Object)28);
            }
            if (integer == 1) {
                return Pair.of((Object)4, (Object)28);
            }
            if (integer == 2) {
                return Pair.of((Object)28, (Object)4);
            }
            return Pair.of((Object)4, (Object)4);
        });

        private final int slots;
        private final int slotAmount;
        private final String displayName;
        private final Function<Integer, Pair<Integer, Integer>> slotPosition;

        private DrawerType(int slots, int slotAmount, String displayName, Function<Integer, Pair<Integer, Integer>> slotPosition) {
            this.slots = slots;
            this.slotAmount = slotAmount;
            this.displayName = displayName;
            this.slotPosition = slotPosition;
        }

        public int getSlots() {
            return this.slots;
        }

        public int getSlotAmount() {
            return this.slotAmount;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Function<Integer, Pair<Integer, Integer>> getSlotPosition() {
            return this.slotPosition;
        }
    }
}

