/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.tasks.OptTask;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.minecraft.client.Minecraft;

public class AnonymousIdentification {
    private static final Preferences userPreferences = Preferences.userRoot().node("dev/ftb/mod/ftbauxilium");
    private static final String location = System.getProperty("user.home") + "/.ftb/mods/ftbauxilium/";
    private static final Path dataPath = Paths.get(location, new String[0]);
    private static final Path identityFile = Paths.get(location + "identity.json", new String[0]);
    private static final Path optOutFlag = Paths.get(location + "dont-track.flag", new String[0]);
    public UUID identifier = this.getOrCreate();
    private boolean optedOut = false;

    public UUID getIdentifier() {
        return this.identifier;
    }

    private UUID getOrCreate() {
        try {
            if (!Files.exists(dataPath, new LinkOption[0])) {
                Files.createDirectories(dataPath, new FileAttribute[0]);
            }
            if (Files.exists(optOutFlag, new LinkOption[0])) {
                this.optedOut = true;
                return UUID.randomUUID();
            }
            if (!Files.exists(identityFile, new LinkOption[0])) {
                UUID uuid = UUID.randomUUID();
                JsonObject object = new JsonObject();
                object.addProperty("identifier", uuid.toString());
                FileWriter writer = new FileWriter(identityFile.toFile());
                new Gson().toJson((JsonElement)object.getAsJsonObject(), (Appendable)writer);
                writer.close();
                return uuid;
            }
            JsonParser parser = new JsonParser();
            JsonElement identity = parser.parse((Reader)new FileReader(identityFile.toFile()));
            if (!identity.isJsonObject() || !identity.getAsJsonObject().has("identifier")) {
                return this.getOrCreateFallback();
            }
            return UUID.fromString(identity.getAsJsonObject().get("identifier").getAsString());
        }
        catch (IOException e) {
            FTBAuxilium.LOGGER.debug("Failed to create required directories", (Throwable)e);
            return this.getOrCreateFallback();
        }
    }

    private UUID getOrCreateFallback() {
        String identifier = userPreferences.get("identifier", "");
        if (identifier.equals("")) {
            UUID uuid = UUID.randomUUID();
            userPreferences.put("identifier", uuid.toString());
            try {
                userPreferences.sync();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            return uuid;
        }
        return UUID.fromString(identifier);
    }

    public boolean optOut() {
        if (!Files.exists(optOutFlag, new LinkOption[0])) {
            try {
                Files.write(optOutFlag, "You have been opted out of FTB auxilium. Remove this file if you would like to opt-in to the stats system.".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                return false;
            }
            Minecraft.m_91087_().execute(() -> FTBAuxilium.runTask(new OptTask(true, this.identifier)));
            this.optedOut = true;
            this.identifier = UUID.randomUUID();
            return true;
        }
        return true;
    }

    public boolean optIn() {
        if (Files.exists(optOutFlag, new LinkOption[0])) {
            try {
                Files.deleteIfExists(optOutFlag);
            }
            catch (IOException e) {
                return false;
            }
            this.optedOut = false;
            this.identifier = this.getOrCreate();
            Minecraft.m_91087_().execute(() -> FTBAuxilium.runTask(new OptTask(false, this.identifier)));
            return true;
        }
        return true;
    }

    public boolean isOptedOut() {
        return this.optedOut;
    }
}

