/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.wirelesschargers.ChargerBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.WirelessChargersClient;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChargerBlock
extends BaseBlock
implements EntityHoldingBlock,
SimpleWaterloggedBlock {
    public final ChargerType type;

    public ChargerBlock(ChargerType type) {
        super(true, BlockProperties.create((Material)Material.f_76279_, (DyeColor)DyeColor.GRAY).destroyTime(2.0f).explosionResistance(2.0f));
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.type.modelType.outlineShape.getUnderlying();
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return this.type.modelType.collisionShape.getUnderlying();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return this.type.createBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (level.f_46443_) {
            WirelessChargersClient.openChargerScreen((Component)TextComponents.block((Block)this).get(), level, pos);
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    protected void appendItemInformation(ItemStack stack, BlockGetter level, Consumer<Component> info, boolean advanced) {
        int redstoneMode;
        int energy;
        MutableComponent transferRate;
        MutableComponent range = TextComponents.number((int)(this.type.range.get() * 2 + 1)).color(ChatFormatting.GOLD).get();
        if (this.type.canChargeBlocks) {
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.blocks", (Object[])new Object[]{range}).color(ChatFormatting.YELLOW).get());
            transferRate = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.type.transferRate.get())).color(ChatFormatting.GOLD).string(" " + EnergyFormat.formatUnitPerTick()).color(ChatFormatting.GRAY).get();
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.transfer_rate_blocks", (Object[])new Object[]{transferRate}).color(ChatFormatting.GRAY).get());
        }
        if (this.type.canChargePlayers) {
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.players", (Object[])new Object[]{range}).color(ChatFormatting.YELLOW).get());
            transferRate = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.type.transferRate.get())).color(ChatFormatting.GOLD).string(" " + EnergyFormat.formatUnitPerTick()).color(ChatFormatting.GRAY).get();
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.transfer_rate_players", (Object[])new Object[]{transferRate}).color(ChatFormatting.GRAY).get());
        }
        int n = energy = stack.m_41783_() == null ? 0 : stack.m_41783_().m_128469_("tileData").m_128451_("energy");
        if (energy > 0) {
            MutableComponent energyText = TextComponents.string((String)EnergyFormat.formatEnergy((int)energy)).color(ChatFormatting.GOLD).get();
            MutableComponent capacity = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.type.capacity.get())).color(ChatFormatting.GOLD).string(" " + EnergyFormat.formatUnit()).color(ChatFormatting.GRAY).get();
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.stored_energy", (Object[])new Object[]{energyText, capacity}).color(ChatFormatting.GRAY).get());
        }
        int n2 = stack.m_41783_() == null ? 2 : (redstoneMode = stack.m_41783_().m_128469_("tileData").m_128441_("redstoneMode") ? stack.m_41783_().m_128469_("tileData").m_128451_("redstoneMode") : 2);
        if (redstoneMode != 2) {
            ChargerBlockEntity.RedstoneMode mode = ChargerBlockEntity.RedstoneMode.fromIndex(redstoneMode);
            MutableComponent value = TextComponents.translation((String)("wirelesschargers.screen.redstone_" + mode.name().toLowerCase(Locale.ROOT))).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.redstone_mode", (Object[])new Object[]{value}).color(ChatFormatting.GRAY).get());
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return direction != Direction.UP;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean p_220069_6_) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof ChargerBlockEntity) {
            ((ChargerBlockEntity)entity).setRedstonePowered(world.m_46753_(pos));
        }
    }
}

