/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;

public class ProgressStyle
implements IProgressStyle {
    public boolean autoTextColor = true;
    public int color;
    public int color2;
    public int textColor;
    public boolean vertical;
    public IElement overlay;
    public boolean glowText;
    public boolean shadow = true;

    public ProgressStyle() {
        this.color(-1);
    }

    @Override
    public IProgressStyle color(int color, int color2) {
        this.color = color;
        this.color2 = color2;
        return this;
    }

    @Override
    public IProgressStyle vertical(boolean vertical) {
        this.vertical = vertical;
        return this;
    }

    @Override
    public IProgressStyle overlay(IElement overlay) {
        this.overlay = overlay;
        return this;
    }

    @Override
    public void render(PoseStack matrixStack, float x, float y, float width, float height, float progress, Component text) {
        progress *= this.choose(true, width, height);
        float progressY = y;
        if (this.vertical) {
            progressY += height - progress;
        }
        if (progress > 0.0f) {
            if (this.overlay != null) {
                Vec2 size = new Vec2(this.choose(true, progress, width), this.choose(false, progress, height));
                this.overlay.size(size);
                this.overlay.render(matrixStack, x, progressY, size.f_82470_, size.f_82471_);
            } else {
                int alpha = (int)((float)(this.color >> 24 & 0xFF) * 0.7f);
                int lighter = this.color & 0xFFFFFF | alpha << 24;
                float half = this.choose(true, height, width) / 2.0f;
                DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, progressY, this.choose(true, progress, half), this.choose(false, progress, half), lighter, this.color, this.vertical);
                DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + this.choose(false, half, 0.0f), progressY + this.choose(true, half, 0.0f), this.choose(true, progress, half), this.choose(false, progress, half), this.color, lighter, this.vertical);
                if (this.color != this.color2) {
                    if (this.vertical) {
                        for (float yy = y + height; yy > progressY; yy -= 2.0f) {
                            float fy = Math.max(progressY, yy + 1.0f);
                            DisplayHelper.fill(matrixStack, x, yy, x + width, fy, this.color2);
                        }
                    } else {
                        for (float xx = x + 1.0f; xx < x + progress; xx += 2.0f) {
                            float fx = Math.min(x + width, xx + 1.0f);
                            DisplayHelper.fill(matrixStack, xx, y, fx, y + height, this.color2);
                        }
                    }
                }
            }
        }
        if (text != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            if (this.autoTextColor) {
                this.autoTextColor = false;
                if (this.overlay == null && ProgressStyle.RGBtoHSV(this.color2).m_122269_() > 0.75f) {
                    this.textColor = -16777216;
                    this.shadow = false;
                } else {
                    this.textColor = -1;
                }
            }
            Objects.requireNonNull(font);
            y += height - 9.0f;
            if (this.vertical) {
                Objects.requireNonNull(font);
                if (9.0f < progress) {
                    y -= progress;
                    Objects.requireNonNull(font);
                    y += (float)(9 + 2);
                }
            }
            int color = IWailaConfig.IConfigOverlay.applyAlpha(this.textColor, OverlayRenderer.alpha);
            if (this.glowText) {
                MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_168645_(text.m_7532_(), x + 1.0f, y, -1, -13421773, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)multibuffersource$buffersource, 0xF000F0);
                multibuffersource$buffersource.m_109911_();
            } else if (this.shadow) {
                font.m_92763_(matrixStack, text, x + 1.0f, y, color);
            } else {
                font.m_92889_(matrixStack, text, x + 1.0f, y, color);
            }
        }
    }

    private float choose(boolean expand, float x, float y) {
        return this.vertical ^ expand ? x : y;
    }

    private static Vector3f RGBtoHSV(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int max = Math.max(r, Math.max(g, b));
        int min = Math.min(r, Math.min(g, b));
        float v = max;
        float delta = max - min;
        if (max == 0) {
            float s = 0.0f;
            float h = -1.0f;
            return new Vector3f(h, s, 0.0f);
        }
        float s = delta / (float)max;
        float h = r == max ? (float)(g - b) / delta : (g == max ? 2.0f + (float)(b - r) / delta : 4.0f + (float)(r - g) / delta);
        h /= 6.0f;
        if (h < 0.0f) {
            h += 1.0f;
        }
        return new Vector3f(h, s, v / 255.0f);
    }

    @Override
    public IProgressStyle textColor(int color) {
        this.textColor = color;
        this.autoTextColor = false;
        return this;
    }

    public IProgressStyle glowText(boolean glowText) {
        this.glowText = glowText;
        return this;
    }
}

