/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage;

import java.util.Optional;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.input.ClickableIngredient;
import mezz.jei.common.util.ImmutableRect2i;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminalscompat.modcompat.jei.JEIIntegratedTerminalsConfig;
import org.jetbrains.annotations.NotNull;

public class TerminalStorageGuiHandler
implements IGuiContainerHandler<ContainerScreenTerminalStorage<?, ?>> {
    @NotNull
    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(@NotNull ContainerScreenTerminalStorage<?, ?> containerScreen, double mouseX, double mouseY) {
        Optional<IClickableIngredient<?>> clickableIngredientOptional = this.createClickableIngredient(containerScreen, mouseX, mouseY);
        return clickableIngredientOptional.map(clickableIngredient -> clickableIngredient);
    }

    private <T> Optional<IClickableIngredient<T>> createClickableIngredient(ContainerScreenTerminalStorage<T, ?> containerScreen, double mouseX, double mouseY) {
        int slotIndex = containerScreen.getStorageSlotIndexAtPosition(mouseX, mouseY);
        Optional<TerminalStorageTabIngredientComponentClient> tabOptional = containerScreen.getSelectedClientTab().filter(TerminalStorageTabIngredientComponentClient.class::isInstance).map(TerminalStorageTabIngredientComponentClient.class::cast);
        if (slotIndex >= 0 && tabOptional.isPresent()) {
            TerminalStorageTabIngredientComponentClient tab = tabOptional.get();
            int channel = ((ContainerTerminalStorageBase)((Object)containerScreen.getMenu())).getSelectedChannel();
            IIngredientManager ingredientManager = JEIIntegratedTerminalsConfig.jeiRuntime.getIngredientManager();
            Optional<Object> instanceOptional = tab.getSlotInstance(channel, slotIndex);
            Optional ingredientTypeOptional = instanceOptional.flatMap(arg_0 -> ((IIngredientManager)ingredientManager).getIngredientTypeChecked(arg_0));
            if (instanceOptional.isPresent() && ingredientTypeOptional.isPresent()) {
                ImmutableRect2i slotRect = new ImmutableRect2i(containerScreen.getStorageSlotRect(slotIndex));
                Optional typedIngredientOptional = ingredientManager.createTypedIngredient((IIngredientType)ingredientTypeOptional.get(), instanceOptional.get());
                return typedIngredientOptional.map(typedIngredient -> new ClickableIngredient(typedIngredient, slotRect));
            }
        }
        return Optional.empty();
    }
}

