/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientItemStackCraftingGridBalance
extends PacketCodec {
    @CodecField
    private String tabId;

    public TerminalStorageIngredientItemStackCraftingGridBalance() {
    }

    public TerminalStorageIngredientItemStackCraftingGridBalance(String tabId) {
        this.tabId = tabId;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ContainerTerminalStorageBase container;
        if (player.f_36096_ instanceof ContainerTerminalStorageBase && (container = (ContainerTerminalStorageBase)player.f_36096_).getTabServer(this.tabId) instanceof TerminalStorageTabIngredientComponentServer) {
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommon = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)container.getTabCommon(this.tabId);
            tabCommon.getInventoryCraftResult().m_6836_(0, ItemStack.f_41583_);
            TerminalStorageIngredientItemStackCraftingGridBalance.balanceGrid(tabCommon.getInventoryCrafting());
        }
    }

    public static void balanceGrid(CraftingContainer craftingGrid) {
        ArrayList bins = Lists.newArrayListWithExpectedSize((int)craftingGrid.m_6643_());
        for (int slot = 0; slot < craftingGrid.m_6643_(); ++slot) {
            ItemStack itemStack = craftingGrid.m_8020_(slot);
            if (itemStack.m_41619_()) continue;
            int amount = itemStack.m_41613_();
            itemStack = itemStack.m_41777_();
            itemStack.m_41764_(1);
            boolean addedToBin = false;
            for (int bin = 0; bin < bins.size() && !addedToBin; ++bin) {
                Pair pair = (Pair)bins.get(bin);
                ItemStack original = ((ItemStack)pair.getLeft()).m_41777_();
                original.m_41764_(1);
                if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)original, (ItemStack)itemStack)) continue;
                ((ItemStack)pair.getLeft()).m_41769_(amount);
                ((List)pair.getRight()).add(new MutablePair((Object)slot, (Object)0));
                addedToBin = true;
            }
            if (addedToBin) continue;
            itemStack.m_41764_(amount);
            bins.add(new MutablePair((Object)itemStack, (Object)Lists.newArrayList((Object[])new Pair[]{new MutablePair((Object)slot, (Object)0)})));
        }
        for (Pair pair : bins) {
            int division = ((ItemStack)pair.getLeft()).m_41613_() / ((List)pair.getRight()).size();
            int modulus = ((ItemStack)pair.getLeft()).m_41613_() % ((List)pair.getRight()).size();
            for (Pair slot : (List)pair.getRight()) {
                slot.setValue((Object)(division + Math.max(0, Math.min(1, modulus--))));
            }
        }
        for (Pair pair : bins) {
            for (Pair slot : (List)pair.getRight()) {
                ItemStack itemStack = ((ItemStack)pair.getKey()).m_41777_();
                itemStack.m_41764_(((Integer)slot.getRight()).intValue());
                craftingGrid.m_6836_(((Integer)slot.getKey()).intValue(), itemStack);
            }
        }
    }
}

