/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.part.PartTypeTerminalCraftingJob;

public class ContainerTerminalCraftingJobs
extends ContainerMultipart<PartTypeTerminalCraftingJob, PartStateEmpty<PartTypeTerminalCraftingJob>> {
    private final LazyOptional<INetwork> network = this.getTarget().map(t -> NetworkHelpers.getNetwork((PartPos)t.getCenter())).orElse(LazyOptional.empty());
    private final int valueIdCraftingJobs;
    private long lastUpdate = 0L;
    private List<HandlerWrappedTerminalCraftingPlan> craftingJobs = Lists.newArrayList();

    public ContainerTerminalCraftingJobs(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, PartHelpers.readPartTarget((FriendlyByteBuf)packetBuffer), Optional.empty(), (PartTypeTerminalCraftingJob)PartHelpers.readPart((FriendlyByteBuf)packetBuffer));
    }

    public ContainerTerminalCraftingJobs(int id, Inventory playerInventory, PartTarget target, Optional<IPartContainer> partContainer, PartTypeTerminalCraftingJob partType) {
        super(RegistryEntries.CONTAINER_PART_TERMINAL_CRAFTING_JOBS, id, playerInventory, (Container)new SimpleContainer(new ItemStack[0]), Optional.of(target), partContainer, (IPartType)partType);
        this.valueIdCraftingJobs = this.getNextValueId();
    }

    public LazyOptional<INetwork> getNetwork() {
        return this.network;
    }

    public int getChannel() {
        return -1;
    }

    public int getValueIdCraftingJobs() {
        return this.valueIdCraftingJobs;
    }

    public List<HandlerWrappedTerminalCraftingPlan> getCraftingJobs() {
        return this.craftingJobs;
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.getLevel().m_5776_() && this.lastUpdate < System.currentTimeMillis()) {
            this.getNetwork().ifPresent(network -> {
                this.lastUpdate = System.currentTimeMillis() + (long)GeneralConfig.guiTerminalCraftingJobsUpdateFrequency;
                int channel = this.getChannel();
                this.craftingJobs = Lists.newArrayList();
                for (ITerminalStorageTabIngredientCraftingHandler iTerminalStorageTabIngredientCraftingHandler : TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandlers()) {
                    for (ITerminalCraftingPlan craftingJob : iTerminalStorageTabIngredientCraftingHandler.getCraftingJobs((INetwork)network, channel)) {
                        this.craftingJobs.add(new HandlerWrappedTerminalCraftingPlan(iTerminalStorageTabIngredientCraftingHandler, craftingJob));
                    }
                }
                ListTag tagList = new ListTag();
                for (HandlerWrappedTerminalCraftingPlan craftingJob : this.craftingJobs) {
                    tagList.add((Object)HandlerWrappedTerminalCraftingPlan.serialize(craftingJob));
                }
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128365_("craftingJobs", (Tag)tagList);
                this.setValue(this.valueIdCraftingJobs, compoundTag);
            });
        }
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (valueId == this.valueIdCraftingJobs) {
            ListTag tagList = value.m_128437_("craftingJobs", 10);
            this.craftingJobs = Lists.newArrayListWithExpectedSize((int)tagList.size());
            for (int i = 0; i < tagList.size(); ++i) {
                this.craftingJobs.add(HandlerWrappedTerminalCraftingPlan.deserialize(tagList.m_128728_(i)));
            }
        }
    }
}

