/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackIdSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackNameSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackQuantitySorter;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientComponentTerminalStorageHandlerFluidStack
implements IIngredientComponentTerminalStorageHandler<FluidStack, Integer> {
    private final IngredientComponent<FluidStack, Integer> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerFluidStack(IngredientComponent<FluidStack, Integer> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IngredientComponent<FluidStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Items.f_42447_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInstance(PoseStack matrixStack, FluidStack instance, long maxQuantity, @Nullable String label, AbstractContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<Component> additionalTooltipLines) {
        if (instance != null) {
            if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
                GuiHelpers.renderFluidSlot((GuiComponent)gui, (PoseStack)matrixStack, (FluidStack)instance, (int)x, (int)y);
                RenderItemExtendedSlotCount.getInstance().drawSlotText(Minecraft.m_91087_().f_91062_, new PoseStack(), label != null ? label : GuiHelpers.quantityToScaledString((long)instance.getAmount()), x, y);
            } else {
                GuiHelpers.renderTooltip((AbstractContainerScreen)gui, (PoseStack)matrixStack, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY, () -> {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(((MutableComponent)instance.getDisplayName()).m_130940_(instance.getFluid().getFluidType().getRarity().f_43022_));
                    this.addQuantityTooltip(lines, instance);
                    if (additionalTooltipLines != null) {
                        lines.addAll(additionalTooltipLines);
                    }
                    return lines;
                });
            }
        }
    }

    @Override
    public String formatQuantity(FluidStack instance) {
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.fluid.amount", (Object[])new Object[]{String.format(Locale.ROOT, "%,d", FluidHelpers.getAmount((FluidStack)instance))});
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    @Override
    public FluidStack getInstance(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getFluidInTank(0) : FluidStack.EMPTY).orElse(FluidStack.EMPTY);
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getTankCapacity(0) : 0).orElse(0).intValue();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageFluidInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageFluidIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<FluidStack, Integer> storage, FluidStack maxInstance, Player player) {
        return 0;
    }

    @Override
    public FluidStack insertIntoContainer(IIngredientComponentStorage<FluidStack, Integer> storage, AbstractContainerMenu container, int containerSlot, FluidStack maxInstance, @Nullable Player player, boolean transferFullSelection) {
        ItemStack stack = container.m_38853_(containerSlot).m_7993_();
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), (IFluidHandlerItem)fluidHandler);
            FluidStack moved = FluidStack.EMPTY;
            try {
                moved = (FluidStack)IngredientStorageHelpers.moveIngredientsIterative((IIngredientComponentStorage)storage, itemStorage, (Object)maxInstance, (Object)((Integer)this.ingredientComponent.getMatcher().getExactMatchNoQuantityCondition()), (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.m_38853_(containerSlot).m_5852_(fluidHandler.getContainer());
            container.m_38946_();
            return moved;
        }).orElse(FluidStack.EMPTY);
    }

    protected IIngredientComponentStorage<FluidStack, Integer> getFluidStorage(IngredientComponent<FluidStack, Integer> component, IFluidHandlerItem fluidHandler) {
        return component.getStorageWrapperHandler(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).wrapComponentStorage((Object)fluidHandler);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<FluidStack, Integer> storage, AbstractContainerMenu container, Inventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = container.m_142621_();
        playerStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), (IFluidHandlerItem)fluidHandler);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.m_142503_(fluidHandler.getContainer());
        });
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<FluidStack, Integer> storage, AbstractContainerMenu container, int containerSlot, Inventory playerInventory, int limit) {
        Slot slot = container.m_38853_(containerSlot);
        if (slot.m_8010_(playerInventory.f_35978_)) {
            ItemStack toMoveStack = slot.m_7993_();
            toMoveStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
                IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), (IFluidHandlerItem)fluidHandler);
                try {
                    IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)(limit == -1 ? Long.MAX_VALUE : (long)limit), (boolean)false);
                }
                catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                    // empty catch block
                }
                container.m_38853_(containerSlot).m_5852_(fluidHandler.getContainer());
                container.m_38946_();
            });
        }
    }

    @Override
    public long getActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container) {
        ItemStack toMoveStack = container.m_142621_();
        return toMoveStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getFluidInTank(0).getAmount() : 0).orElse(0).intValue();
    }

    @Override
    public void drainActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container, long quantityIn) {
        ItemStack toMoveStack = container.m_142621_();
        toMoveStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
            int drained;
            for (long quantity = quantityIn; quantity > 0L && (drained = fluidHandler.drain((int)quantity, IFluidHandler.FluidAction.EXECUTE).getAmount()) > 0; quantity -= (long)drained) {
            }
            container.m_142503_(fluidHandler.getContainer());
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<FluidStack> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        return switch (searchMode) {
            default -> throw new IncompatibleClassChangeError();
            case SearchMode.MOD -> i -> ForgeRegistries.FLUIDS.getKey((Object)i.getFluid()).m_135827_().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            case SearchMode.TOOLTIP -> i -> false;
            case SearchMode.TAG -> i -> ForgeRegistries.FLUIDS.tags().getReverseTag((Object)i.getFluid()).map(reverseTag -> reverseTag.getTagKeys().filter(tag -> tag.f_203868_().toString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*")).anyMatch(tag -> !ForgeRegistries.FLUIDS.tags().getTag(tag).isEmpty())).orElse(false);
            case SearchMode.DEFAULT -> i -> i != null && i.getDisplayName().getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
        };
    }

    @Override
    public Collection<IIngredientInstanceSorter<FluidStack>> getInstanceSorters() {
        return Lists.newArrayList((Object[])new IIngredientInstanceSorter[]{new FluidStackNameSorter(), new FluidStackIdSorter(), new FluidStackQuantitySorter()});
    }
}

