/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientComponentTerminalStorageHandlerEnergy
implements IIngredientComponentTerminalStorageHandler<Long, Boolean> {
    private final IngredientComponent<Long, Boolean> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerEnergy(IngredientComponent<Long, Boolean> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IngredientComponent<Long, Boolean> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)RegistryEntries.ITEM_ENERGY_BATTERY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInstance(PoseStack matrixStack, Long instance, long maxQuantity, @Nullable String label, AbstractContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<Component> additionalTooltipLines) {
        if (instance > 0L) {
            if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
                int progressMaxScaled;
                int progressScaled;
                Lighting.m_84930_();
                RenderHelpers.bindTexture((ResourceLocation)Images.ICONS);
                gui.m_93228_(matrixStack, x, y, 0, 240, GuiHelpers.SLOT_SIZE_INNER, GuiHelpers.SLOT_SIZE_INNER);
                if ((long)((int)maxQuantity) == maxQuantity) {
                    progressScaled = (int)instance.longValue();
                    progressMaxScaled = (int)maxQuantity;
                } else {
                    progressScaled = (int)(instance >> 16);
                    progressMaxScaled = (int)(maxQuantity >> 16);
                }
                GuiHelpers.renderProgressBar((GuiComponent)gui, (PoseStack)matrixStack, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)16, (int)240, (GuiHelpers.ProgressDirection)GuiHelpers.ProgressDirection.UP, (int)progressScaled, (int)progressMaxScaled);
                RenderItemExtendedSlotCount.getInstance().drawSlotText(Minecraft.m_91087_().f_91062_, new PoseStack(), label != null ? label : GuiHelpers.quantityToScaledString((long)instance), x, y);
                Lighting.m_84931_();
            } else {
                GuiHelpers.renderTooltip((AbstractContainerScreen)gui, (PoseStack)matrixStack, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY, () -> {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(Component.m_237115_((String)"gui.integratedterminals.terminal_storage.tooltip.energy"));
                    this.addQuantityTooltip(lines, instance);
                    if (additionalTooltipLines != null) {
                        lines.addAll(additionalTooltipLines);
                    }
                    return lines;
                });
            }
        }
    }

    @Override
    public String formatQuantity(Long instance) {
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.energy.amount", (Object[])new Object[]{String.format(Locale.ROOT, "%,d", instance)});
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    @Override
    public Long getInstance(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0).longValue();
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0).intValue();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageEnergyIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<Long, Boolean> storage, Long maxInstance, Player player) {
        return 0;
    }

    protected IIngredientComponentStorage<Long, Boolean> getEnergyStorage(IngredientComponent<Long, Boolean> component, IEnergyStorage energyStorage) {
        return component.getStorageWrapperHandler(CapabilityEnergy.ENERGY).wrapComponentStorage((Object)energyStorage);
    }

    @Override
    public Long insertIntoContainer(IIngredientComponentStorage<Long, Boolean> storage, AbstractContainerMenu container, int containerSlot, Long maxInstance, @Nullable Player player, boolean transferFullSelection) {
        ItemStack stack = container.m_38853_(containerSlot).m_7993_();
        return stack.getCapability(CapabilityEnergy.ENERGY).map(energyStorage -> {
            IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
            Long ret = 0L;
            try {
                ret = (Long)IngredientStorageHelpers.moveIngredientsIterative((IIngredientComponentStorage)storage, itemStorage, (long)maxInstance, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.m_38946_();
            return ret;
        }).orElse(0L);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<Long, Boolean> storage, AbstractContainerMenu container, Inventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = container.m_142621_();
        playerStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
            IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
        });
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<Long, Boolean> storage, AbstractContainerMenu container, int containerSlot, Inventory playerInventory, int limit) {
        Slot slot = container.m_38853_(containerSlot);
        if (slot.m_8010_(playerInventory.f_35978_)) {
            ItemStack toMoveStack = slot.m_7993_();
            toMoveStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
                IIngredientComponentStorage<Long, Boolean> itemStorage = this.getEnergyStorage((IngredientComponent<Long, Boolean>)storage.getComponent(), (IEnergyStorage)energyStorage);
                try {
                    IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)(limit == -1 ? Long.MAX_VALUE : (long)limit), (boolean)false);
                }
                catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public long getActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container) {
        ItemStack toMoveStack = container.m_142621_();
        return toMoveStack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0).intValue();
    }

    @Override
    public void drainActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container, long quantityIn) {
        ItemStack toMoveStack = container.m_142621_();
        toMoveStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
            int drained;
            for (long quantity = quantityIn; quantity > 0L && (drained = energyStorage.extractEnergy((int)quantity, false)) > 0; quantity -= (long)drained) {
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<Long> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        return integer -> true;
    }

    @Override
    public Collection<IIngredientInstanceSorter<Long>> getInstanceSorters() {
        return Collections.emptyList();
    }
}

