/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.client.model.data;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.data.ModelProperty;

public class DuctModelData {
    public static final ModelProperty<DuctModelData> DUCT_MODEL_DATA = new ModelProperty();
    private int state;
    @Nullable
    private ResourceLocation fill;
    @Nullable
    private ResourceLocation[] attachments;
    private int fillColor = 0xFFFFFF;

    public DuctModelData() {
    }

    public DuctModelData(DuctModelData other) {
        this.state = other.state;
        this.fill = other.fill;
        if (other.attachments != null) {
            this.attachments = (ResourceLocation[])other.attachments.clone();
        }
    }

    public void setNeedsRefresh() {
        this.state = -1;
    }

    public void clearState() {
        this.state = 0;
    }

    public boolean needsRefresh() {
        return this.state == -1;
    }

    public void setInternalConnection(Direction dir, boolean present) {
        this.setStateBit(dir.ordinal(), present);
    }

    public void setExternalConnection(Direction dir, boolean present) {
        this.setStateBit(dir.ordinal() + 6, present);
    }

    public void setFill(@Nullable ResourceLocation loc) {
        this.fill = loc;
    }

    public void setFillColor(int color) {
        this.fillColor = color;
    }

    public void setAttachment(Direction dir, @Nullable ResourceLocation loc) {
        if (this.attachments == null) {
            this.attachments = new ResourceLocation[6];
        }
        this.attachments[dir.ordinal()] = loc;
    }

    public boolean hasInternalConnection(Direction dir) {
        return this.isStateBitSet(dir.ordinal());
    }

    public boolean hasExternalConnection(Direction dir) {
        return this.isStateBitSet(dir.ordinal() + 6);
    }

    public int getConnectionState() {
        return this.state;
    }

    private void setStateBit(int bit, boolean value) {
        int state = this.getConnectionState();
        state = value ? (state |= 1 << bit) : (state &= ~(1 << bit));
        this.setConnectionState(state);
    }

    private boolean isStateBitSet(int bit) {
        return (this.state & 1 << bit) > 0;
    }

    private void setConnectionState(int state) {
        this.state = state;
    }

    @Nullable
    public ResourceLocation getFill() {
        return this.fill;
    }

    @Nullable
    public ResourceLocation getAttachment(Direction dir) {
        if (this.attachments == null) {
            return null;
        }
        return this.attachments[dir.ordinal()];
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DuctModelData that = (DuctModelData)o;
        if (this.state != that.state) {
            return false;
        }
        if (!Objects.equals(this.fill, that.fill)) {
            return false;
        }
        return Arrays.equals(this.attachments, that.attachments);
    }

    public int hashCode() {
        int result = this.state;
        result = 31 * result + (this.fill != null ? this.fill.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.attachments);
        return result;
    }
}

