/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Mirror;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Axis {
    X{

        @Override
        public double get(double x, double y, double z) {
            return x;
        }

        @Override
        public float get(float x, float y, float z) {
            return x;
        }

        @Override
        public int get(int x, int y, int z) {
            return x;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return x;
        }

        @Override
        public Axis one() {
            return Y;
        }

        @Override
        public Axis two() {
            return Z;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.EAST : Facing.WEST;
        }

        @Override
        public Direction.Axis toVanilla() {
            return Direction.Axis.X;
        }

        @Override
        public Vec3i mirror(Vec3i vec) {
            return new Vec3i(-vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
        }

        @Override
        public BlockPos mirror(BlockPos vec) {
            return new BlockPos(-vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
        }
    }
    ,
    Y{

        @Override
        public double get(double x, double y, double z) {
            return y;
        }

        @Override
        public float get(float x, float y, float z) {
            return y;
        }

        @Override
        public int get(int x, int y, int z) {
            return y;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return y;
        }

        @Override
        public Axis one() {
            return Z;
        }

        @Override
        public Axis two() {
            return X;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.UP : Facing.DOWN;
        }

        @Override
        public Direction.Axis toVanilla() {
            return Direction.Axis.Y;
        }

        @Override
        public Vec3i mirror(Vec3i vec) {
            return new Vec3i(vec.m_123341_(), -vec.m_123342_(), vec.m_123343_());
        }

        @Override
        public BlockPos mirror(BlockPos vec) {
            return new BlockPos(vec.m_123341_(), -vec.m_123342_(), vec.m_123343_());
        }
    }
    ,
    Z{

        @Override
        public double get(double x, double y, double z) {
            return z;
        }

        @Override
        public float get(float x, float y, float z) {
            return z;
        }

        @Override
        public int get(int x, int y, int z) {
            return z;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return z;
        }

        @Override
        public Axis one() {
            return X;
        }

        @Override
        public Axis two() {
            return Y;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.SOUTH : Facing.NORTH;
        }

        @Override
        public Direction.Axis toVanilla() {
            return Direction.Axis.Z;
        }

        @Override
        public Vec3i mirror(Vec3i vec) {
            return new Vec3i(vec.m_123341_(), vec.m_123342_(), -vec.m_123343_());
        }

        @Override
        public BlockPos mirror(BlockPos vec) {
            return new BlockPos(vec.m_123341_(), vec.m_123342_(), -vec.m_123343_());
        }
    };


    public static Axis get(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return X;
            }
            case Y: {
                return Y;
            }
            case Z: {
                return Z;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Axis third(Axis one, Axis two) {
        switch (one) {
            case X: {
                if (two == Y) {
                    return Z;
                }
                return Y;
            }
            case Y: {
                if (two == X) {
                    return Z;
                }
                return X;
            }
            case Z: {
                if (two == Y) {
                    return X;
                }
                return Y;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Axis getMirrorAxis(Mirror mirrorIn) {
        switch (mirrorIn) {
            case FRONT_BACK: {
                return X;
            }
            case LEFT_RIGHT: {
                return Z;
            }
        }
        return null;
    }

    public abstract Axis one();

    public abstract Axis two();

    public abstract Facing facing(boolean var1);

    public abstract double get(double var1, double var3, double var5);

    public abstract float get(float var1, float var2, float var3);

    public abstract int get(int var1, int var2, int var3);

    public abstract <T> T get(T var1, T var2, T var3);

    public abstract Direction.Axis toVanilla();

    public Facing mirror(Facing facing) {
        if (facing.axis == this) {
            return facing.opposite();
        }
        return facing;
    }

    public Direction mirror(Direction facing) {
        if (facing.m_122434_() == this.toVanilla()) {
            return facing.m_122424_();
        }
        return facing;
    }

    public abstract Vec3i mirror(Vec3i var1);

    public abstract BlockPos mirror(BlockPos var1);

    public void mirror(Vec3d vec) {
        vec.set(this, -vec.get(this));
    }

    public void mirror(Vec3f vec) {
        vec.set(this, -vec.get(this));
    }
}

