/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.manager;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlot;
import team.creative.creativecore.common.gui.controls.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.gui.sync.GuiSyncGlobal;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiManagerItem
extends GuiManager {
    private static final GuiSyncGlobal<GuiLayer, CompoundTag> HAND = GuiSyncHolder.GLOBAL.register("hand", (c, t) -> c.itemManager().setHand(ItemStack.m_41712_((CompoundTag)t)));
    public static final GuiSyncGlobal<GuiSlot, ByteTag> DROP = GuiSyncHolder.GLOBAL.register("drop", (c, t) -> {
        boolean ctrl = t.m_7063_() == 1;
        Slot slot = c.slot;
        Player player = c.getPlayer();
        if (slot.m_6657_() && slot.m_8010_(player)) {
            ItemStack drop = slot.m_7993_().m_41777_();
            if (ctrl) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                drop.m_41764_(1);
            }
            ItemStack newStack = slot.m_7993_();
            newStack.m_41774_(1);
            player.m_36176_(drop, true);
            slot.m_142406_(player, drop);
            c.changed();
        }
    });
    public static final GuiSyncGlobal<GuiLayer, EndTag> DROP_HAND = GuiSyncHolder.GLOBAL.register("drop_hand", (c, t) -> {
        ItemStack hand = c.itemManager().getHand();
        Player player = c.getPlayer();
        if (!hand.m_41619_()) {
            player.m_36176_(hand, true);
            c.itemManager().setHand(ItemStack.f_41583_);
        }
    });
    public static final GuiSyncGlobal<GuiSlot, IntTag> INSERT = GuiSyncHolder.GLOBAL.register("insert", (c, t) -> {
        Slot slot = c.slot;
        GuiLayer layer = c.getLayer();
        ItemStack stack = slot.m_7993_();
        int amount = Math.min(t.m_7047_(), stack.m_41613_());
        ItemStack insert = stack.m_41777_();
        insert.m_41764_(amount);
        stack.m_41774_(amount);
        for (IGuiInventory inv : layer.inventoriesToInsert()) {
            if (inv == c.inventory()) continue;
            inv.insert(insert, false);
            if (!insert.m_41619_()) {
                inv.insert(insert, true);
            }
            if (!insert.m_41619_()) continue;
            break;
        }
        stack.m_41769_(insert.m_41613_());
        c.changed();
    });
    public static final GuiSyncGlobal<GuiSlot, IntTag> EXTRACT = GuiSyncHolder.GLOBAL.register("exract", (c, t) -> {
        Slot slot = c.slot;
        GuiLayer layer = c.getLayer();
        ItemStack stack = slot.m_7993_();
        if (stack.m_41619_()) {
            return;
        }
        int amount = Math.min(t.m_7047_(), slot.m_5866_(stack) - stack.m_41613_());
        ItemStack extract = stack.m_41777_();
        extract.m_41764_(amount);
        for (IGuiInventory inv : layer.inventoriesToExract()) {
            if (inv == c.inventory()) continue;
            inv.extract(extract);
            if (!extract.m_41619_()) continue;
            break;
        }
        stack.m_41769_(amount - extract.m_41613_());
        c.changed();
    });
    public static final GuiSyncGlobal<GuiSlot, EndTag> DUPLICATE = GuiSyncHolder.GLOBAL.register("duplicate", (c, t) -> {
        Slot slot = c.slot;
        Player player = c.getPlayer();
        if (player.m_7500_()) {
            ItemStack stack = slot.m_7993_().m_41777_();
            stack.m_41764_(stack.m_41741_());
            c.itemManager().setHand(stack);
        }
    });
    public static final GuiSyncGlobal<GuiSlot, ByteTag> SWAP = GuiSyncHolder.GLOBAL.register("swap", (c, t) -> {
        boolean rightClick = t.m_7063_() == 1;
        Slot slot = c.slot;
        Player player = c.getPlayer();
        ItemStack hand = c.itemManager().getHand();
        if (slot.m_8010_(player) && (hand.m_41619_() || slot.m_5857_(hand))) {
            ItemStack pickup;
            if (hand.m_41619_() && rightClick) {
                pickup = slot.m_7993_().m_41620_(Math.max(1, slot.m_7993_().m_41613_() / 2));
            } else {
                pickup = slot.m_7993_().m_41777_();
                slot.m_5852_(hand.m_41777_());
            }
            slot.m_142406_(player, pickup);
            c.itemManager().setHand(pickup);
            c.changed();
        }
    });
    public static final GuiSyncGlobal<GuiLayer, CompoundTag> SPREAD = GuiSyncHolder.GLOBAL.register("spread", (c, t) -> {
        ItemStack hand = c.itemManager().getHand().m_41777_();
        Player player = c.getPlayer();
        if (hand.m_41619_()) {
            return;
        }
        ArrayList<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
        ListTag names = t.m_128437_("names", 8);
        for (int i = 0; i < names.size(); ++i) {
            inventories.add((IGuiInventory)c.get(names.m_128778_(i)));
        }
        ArrayList<GuiSlot> slots = new ArrayList<GuiSlot>();
        int[] ids = t.m_128465_("ids");
        for (int i = 0; i < ids.length; i += 2) {
            slots.add(((IGuiInventory)inventories.get(ids[i])).getSlot(ids[i + 1]));
        }
        int countPerSlot = Math.max(1, Mth.m_14143_((float)((float)hand.m_41613_() / (float)slots.size())));
        boolean rightClick = t.m_128471_("rightClick");
        if (rightClick) {
            countPerSlot = 1;
        }
        for (GuiSlot slot : slots) {
            if (!slot.slot.m_5857_(hand)) continue;
            ItemStack stack = slot.getStack();
            int transfer = Math.min(countPerSlot, slot.slot.m_5866_(hand) - slot.getStack().m_41613_());
            ItemStack toTransfer = hand.m_41777_();
            toTransfer.m_41764_(transfer);
            if (transfer <= 0) continue;
            if (!toTransfer.m_150926_(slot.slot, rightClick ? ClickAction.SECONDARY : ClickAction.PRIMARY, player) && !stack.m_150932_(toTransfer, slot.slot, rightClick ? ClickAction.SECONDARY : ClickAction.PRIMARY, player, c.itemManager().handAccess)) {
                if (!slot.slot.m_6657_()) {
                    slot.slot.m_5852_(toTransfer);
                } else {
                    if (!ItemStack.m_150942_((ItemStack)toTransfer, (ItemStack)stack)) continue;
                    stack.m_41769_(transfer);
                }
                hand.m_41774_(transfer);
            } else {
                hand = c.itemManager().getHand();
            }
            slot.changed();
        }
        c.itemManager().setHand(hand);
    });
    private ItemStack hand = ItemStack.f_41583_;
    private boolean drag;
    private boolean rightClick;
    private List<GuiSlot> dragged;
    private List<Integer> stackSizes;
    private boolean handChanged;
    public SlotAccess handAccess = new SlotAccess(){

        public ItemStack m_142196_() {
            return GuiManagerItem.this.getHand();
        }

        public boolean m_142104_(ItemStack hand) {
            GuiManagerItem.this.setHand(hand);
            return true;
        }
    };

    public static int freeSpace(Slot slot, ItemStack hand) {
        if (slot.m_5857_(hand) && AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)hand, (boolean)true)) {
            int stackSize = slot.m_5866_(hand);
            if (slot.m_6657_()) {
                stackSize -= slot.m_7993_().m_41613_();
            }
            return stackSize;
        }
        return -1;
    }

    public GuiManagerItem(GuiLayer layer) {
        super(layer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(PoseStack matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        ItemStack stack = this.hand;
        int count = stack.m_41613_();
        if (this.drag) {
            int used = 0;
            int countPerSlot = Math.max(1, Mth.m_14143_((float)((float)this.hand.m_41613_() / (float)this.stackSizes.size())));
            if (this.rightClick) {
                countPerSlot = 1;
            }
            for (int i = 0; i < this.stackSizes.size(); ++i) {
                used += Math.min(countPerSlot, this.stackSizes.get(i));
            }
            int left = this.hand.m_41613_() - used;
            count = Math.max(0, left);
        }
        if (!(stack.m_41619_() || this.drag && !this.rightClick && this.dragged.size() <= 1)) {
            matrix.m_85836_();
            RenderSystem.m_69471_();
            matrix.m_85837_((double)(mouseX - 8), (double)(mouseY - 8), 200.0);
            GuiRenderHelper.drawItemStack(matrix, stack, 1.0f);
            GuiRenderHelper.drawItemStackDecorations(matrix, stack, count);
            matrix.m_85849_();
        }
    }

    @Override
    public void tick() {
        if (this.handChanged) {
            this.handChanged = false;
            if (!this.layer.isClient()) {
                HAND.send(this.layer, this.hand.m_41739_(new CompoundTag()));
            }
        }
        super.tick();
    }

    @Override
    public void closed() {
        if (!(this.layer.isClient() || this.hand.m_41619_() || this.layer.getPlayer().m_36356_(this.hand))) {
            this.layer.getPlayer().m_36176_(this.hand, false);
        }
        super.closed();
    }

    @Override
    public void mouseClickedOutside(double x, double y) {
        if (!this.hand.m_41619_()) {
            DROP_HAND.send(this.layer, EndTag.f_128534_);
        }
    }

    @Override
    public void mouseReleased(double x, double y, int button) {
        if (this.isDragged() && this.rightClick == (button == 1)) {
            this.endDrag();
        }
    }

    public void startDrag(GuiSlot slot, boolean rightClick, int stackSize) {
        this.drag = true;
        this.dragged = new ArrayList<GuiSlot>();
        this.dragged.add(slot);
        this.rightClick = rightClick;
        this.stackSizes = new ArrayList<Integer>();
        this.stackSizes.add(stackSize);
        slot.draggedIndex = 0;
    }

    public void addToDrag(GuiSlot slot) {
        int stackSize = GuiManagerItem.freeSpace(slot.slot, this.hand);
        if (stackSize > 0) {
            slot.draggedIndex = this.dragged.size();
            this.dragged.add(slot);
            this.stackSizes.add(stackSize);
        }
    }

    public void modifyDrag(GuiSlot slot) {
        this.stackSizes.set(slot.draggedIndex, GuiManagerItem.freeSpace(slot.slot, this.hand));
    }

    public void abortDrag() {
        for (GuiSlot slot : this.dragged) {
            slot.draggedIndex = -1;
        }
        this.drag = false;
        this.rightClick = false;
        this.dragged = null;
        this.stackSizes = null;
    }

    public void endDrag() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("rightClick", this.rightClick);
        HashMap<String, Integer> inventories = new HashMap<String, Integer>();
        ListTag names = new ListTag();
        int[] ids = new int[this.dragged.size() * 2];
        int i = 0;
        for (GuiSlot slot : this.dragged) {
            String inventory = slot.inventory().name();
            Integer inventoryId = (Integer)inventories.get(inventory);
            if (inventoryId == null) {
                inventoryId = inventories.size();
                inventories.put(inventory, inventoryId);
                names.add((Object)StringTag.m_129297_((String)inventory));
            }
            ids[i] = inventoryId;
            ids[i + 1] = slot.slot.m_150661_();
            i += 2;
        }
        nbt.m_128385_("ids", ids);
        nbt.m_128365_("names", (Tag)names);
        SPREAD.sendAndExecute(this.layer, nbt);
        if (this.isDragged()) {
            this.abortDrag();
        }
    }

    public boolean isDragged() {
        return this.drag;
    }

    public ItemStack getHand() {
        return this.hand;
    }

    public void setHandChanged() {
        this.handChanged = true;
    }

    public void setHand(ItemStack stack) {
        if (this.isDragged()) {
            this.abortDrag();
        }
        this.hand = stack;
        this.setHandChanged();
    }

    public int additionalDragCount(int index) {
        if (index >= this.hand.m_41613_()) {
            return 0;
        }
        if (this.rightClick) {
            return 1;
        }
        return Math.max(1, Mth.m_14143_((float)(this.hand.m_41613_() / this.dragged.size())));
    }
}

