/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.maxhenkel.easy_villagers.corelib.CachedMap;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class TraderRenderer
extends VillagerRendererBase<TraderTileentity> {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final CachedMap<Block, BlockState> blockStateCache = new CachedMap(10000L);
    public static final Map<ResourceLocation, Consumer<PoseStack>> TRANSFORMS = new HashMap<ResourceLocation, Consumer<PoseStack>>();
    private static final Map<Block, Consumer<PoseStack>> TRANSFORMS_CACHE = new HashMap<Block, Consumer<PoseStack>>();
    public static final Map<ResourceLocation, ResourceLocation> TOP_BLOCKS = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Map<Block, BlockState> TOP_BLOCK_CACHE = new HashMap<Block, BlockState>();

    public TraderRenderer(BlockEntityRendererProvider.Context renderer) {
        super(renderer);
    }

    @Override
    public void render(TraderTileentity trader, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(trader, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        TraderRenderer.renderTraderBase(this.villagerRenderer, trader, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public static void renderTraderBase(VillagerRenderer renderer, TraderTileentityBase trader, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrixStack.m_85836_();
        Direction direction = Direction.SOUTH;
        if (!trader.isFakeWorld()) {
            direction = (Direction)trader.m_58900_().m_61143_((Property)TraderBlock.FACING);
        }
        if (trader.getVillagerEntity() != null) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.0625, 0.5);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-direction.m_122435_()));
            matrixStack.m_85837_(0.0, 0.0, -0.25);
            matrixStack.m_85841_(0.45f, 0.45f, 0.45f);
            renderer.m_7392_((Mob)trader.getVillagerEntity(), 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            matrixStack.m_85849_();
        }
        if (trader.hasWorkstation()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.0625, 0.5);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-direction.m_122435_()));
            matrixStack.m_85837_(0.0, 0.0, 0.125);
            matrixStack.m_85837_(-0.5, 0.0, -0.5);
            matrixStack.m_85841_(0.45f, 0.45f, 0.45f);
            matrixStack.m_85837_(0.6111111111111112, 0.0, 0.6111111111111112);
            BlockState workstation = TraderRenderer.getState(trader.getWorkstation());
            TraderRenderer.getTransforms(workstation).accept(matrixStack);
            TraderRenderer.renderBlock(workstation, matrixStack, buffer, combinedLight, combinedOverlay);
            BlockState topBlock = TraderRenderer.getTopBlock(workstation);
            if (!topBlock.m_60795_()) {
                matrixStack.m_85837_(0.0, 1.0, 0.0);
                TraderRenderer.renderBlock(topBlock, matrixStack, buffer, combinedLight, combinedOverlay);
            }
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    public static void renderBlock(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        mc.m_91289_().m_110912_(state, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public static BlockState getState(Block block) {
        return blockStateCache.get(block, () -> TraderRenderer.getFittingState(block));
    }

    protected static BlockState getFittingState(Block block) {
        if (block == Blocks.f_50623_) {
            return (BlockState)block.m_49966_().m_61124_((Property)GrindstoneBlock.f_53179_, (Comparable)AttachFace.FLOOR);
        }
        return block.m_49966_();
    }

    protected static Consumer<PoseStack> getTransforms(BlockState block) {
        Consumer<PoseStack> cached = TRANSFORMS_CACHE.get(block.m_60734_());
        if (cached != null) {
            return cached;
        }
        Consumer<PoseStack> transform = TRANSFORMS.get(ForgeRegistries.BLOCKS.getKey((Object)block.m_60734_()));
        if (transform == null) {
            transform = stack -> {};
        }
        TRANSFORMS_CACHE.put(block.m_60734_(), transform);
        return transform;
    }

    protected static BlockState getTopBlock(BlockState bottom) {
        BlockState cached = TOP_BLOCK_CACHE.get(bottom.m_60734_());
        if (cached != null) {
            return cached;
        }
        ResourceLocation resourceLocation = TOP_BLOCKS.get(ForgeRegistries.BLOCKS.getKey((Object)bottom.m_60734_()));
        if (resourceLocation == null) {
            BlockState state = Blocks.f_50016_.m_49966_();
            TOP_BLOCK_CACHE.put(bottom.m_60734_(), state);
            return state;
        }
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (b == null) {
            BlockState state = Blocks.f_50016_.m_49966_();
            TOP_BLOCK_CACHE.put(bottom.m_60734_(), state);
            return state;
        }
        BlockState state = b.m_49966_();
        TOP_BLOCK_CACHE.put(bottom.m_60734_(), state);
        return state;
    }

    static {
        Consumer<PoseStack> immersiveEngineering = stack -> stack.m_85837_(-0.5, 0.0, 0.0);
        TRANSFORMS.put(new ResourceLocation("immersiveengineering", "workbench"), immersiveEngineering);
        TRANSFORMS.put(new ResourceLocation("immersiveengineering", "circuit_table"), immersiveEngineering);
        TOP_BLOCKS.put(new ResourceLocation("car", "gas_station"), new ResourceLocation("car", "gas_station_top"));
    }
}

