/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.OutputItemHandler;
import de.maxhenkel.easyvillagers.blocks.FarmerBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class FarmerTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected BlockState crop;
    protected NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected LazyOptional<OutputItemHandler> outputItemHandler = LazyOptional.of(() -> new OutputItemHandler(this.inventory));
    protected ItemStackHandler itemHandler = new ItemStackHandler(this.inventory);

    public FarmerTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.FARMER.get(), ((FarmerBlock)ModBlocks.FARMER.get()).m_49966_(), pos, state);
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        if (villager.m_7809_() <= 0 && !villager.m_7141_().m_35571_().equals((Object)VillagerProfession.f_35596_)) {
            villager.m_34375_(villager.m_7141_().m_35565_(VillagerProfession.f_35590_));
        }
    }

    public void setCrop(Item seed) {
        this.crop = seed == null ? null : this.getSeedCrop(seed);
        this.m_6596_();
        this.sync();
    }

    public Block removeSeed() {
        if (this.crop == null) {
            return null;
        }
        Block s = this.crop.m_60734_();
        this.setCrop(null);
        return s;
    }

    public boolean isValidSeed(Item seed) {
        return this.getSeedCrop(seed) != null;
    }

    public BlockState getSeedCrop(Item seed) {
        IPlantable plantable;
        if (seed == Items.f_42404_) {
            return Blocks.f_50092_.m_49966_();
        }
        if (seed == Items.f_42620_) {
            return Blocks.f_50250_.m_49966_();
        }
        if (seed == Items.f_42619_) {
            return Blocks.f_50249_.m_49966_();
        }
        if (seed == Items.f_42733_) {
            return Blocks.f_50444_.m_49966_();
        }
        if (seed instanceof IPlantable && (plantable = (IPlantable)seed).getPlantType((BlockGetter)this.f_58857_, this.m_58899_()) == PlantType.CROP) {
            return plantable.getPlant((BlockGetter)this.f_58857_, this.m_58899_());
        }
        return null;
    }

    @Nullable
    public BlockState getCrop() {
        return this.crop;
    }

    @Override
    public void tickServer() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v != null) {
            VillagerBlockBase.playRandomVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12503_);
            if (this.advanceAge()) {
                this.sync();
            }
            this.m_6596_();
        }
        if (this.f_58857_.m_46467_() % 20L == 0L && this.f_58857_.f_46441_.m_188503_(((Integer)Main.SERVER_CONFIG.farmSpeed.get()).intValue()) == 0 && this.ageCrop(v)) {
            this.sync();
            this.m_6596_();
        }
    }

    private boolean ageCrop(@Nullable EasyVillagerEntity villager) {
        BlockState c = this.getCrop();
        if (c == null) {
            return false;
        }
        Optional<Property> ageProp = c.m_61147_().stream().filter(p -> p.m_61708_().equals("age")).findFirst();
        if (!ageProp.isPresent() || !(ageProp.get() instanceof IntegerProperty)) {
            return false;
        }
        IntegerProperty p2 = (IntegerProperty)ageProp.get();
        Integer max = (Integer)p2.m_6908_().stream().max(Integer::compare).get();
        int age = (Integer)c.m_61143_((Property)p2);
        if (age >= max) {
            if (villager == null || villager.m_6162_() || !villager.m_7141_().m_35571_().equals((Object)VillagerProfession.f_35590_)) {
                return false;
            }
            LootContext.Builder context = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_())).m_78972_(LootContextParams.f_81461_, (Object)c).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
            List drops = c.m_60724_(context);
            for (ItemStack stack : drops) {
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    stack = this.itemHandler.insertItem(i, stack, false);
                }
            }
            this.crop = (BlockState)this.crop.m_61124_((Property)p2, (Comparable)Integer.valueOf(0));
            VillagerBlockBase.playVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12567_);
            return true;
        }
        this.crop = (BlockState)this.crop.m_61124_((Property)p2, (Comparable)Integer.valueOf(age + 1));
        return true;
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.inventory, () -> ((FarmerTileentity)this).m_6596_());
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.crop != null) {
            compound.m_128365_("Crop", (Tag)NbtUtils.m_129202_((BlockState)this.crop));
        }
        ContainerHelper.m_18976_((CompoundTag)compound, this.inventory, (boolean)false);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("Crop")) {
            this.crop = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("Crop"));
        } else {
            this.removeSeed();
        }
        ContainerHelper.m_18980_((CompoundTag)compound, this.inventory);
        super.m_142466_(compound);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.outputItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        this.outputItemHandler.invalidate();
        super.m_7651_();
    }
}

