/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter;

import com.google.gson.JsonObject;
import com.oierbravo.createsifter.ModRecipeTypes;
import com.oierbravo.createsifter.content.contraptions.components.meshes.BaseMesh;
import com.simibubi.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class SiftingRecipe
extends AbstractCrushingRecipe {
    ItemStack meshStack = this.getMeshItemStack();
    ItemStack siftableIngredienStack = this.getSiftableItemStack();
    private boolean waterlogged = false;

    public SiftingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)ModRecipeTypes.SIFTING, params);
    }

    public boolean matches(RecipeWrapper inv, Level worldIn, boolean waterlogged) {
        if (inv.m_7983_()) {
            return false;
        }
        if (this.isWaterlogged() != waterlogged) {
            return false;
        }
        return this.getSiftableIngredient().test(inv.m_8020_(0)) && this.getMeshIngredient().test(inv.m_8020_(1));
    }

    public ItemStack getMeshItemStack() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = ((Ingredient)this.ingredients.get(i)).m_43908_()[0];
            if (!SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getSiftableItemStack() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = ((Ingredient)this.ingredients.get(i)).m_43908_()[0];
            if (SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public Ingredient getSiftableIngredient() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = ((Ingredient)this.ingredients.get(i)).m_43908_()[0];
            if (SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return (Ingredient)this.ingredients.get(i);
        }
        return Ingredient.f_43901_;
    }

    public Ingredient getMeshIngredient() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = ((Ingredient)this.ingredients.get(i)).m_43908_()[0];
            if (!SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return (Ingredient)this.ingredients.get(i);
        }
        return Ingredient.f_43901_;
    }

    public static boolean isMeshItemStack(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BaseMesh;
    }

    public String toString() {
        return "createsifter:sifting";
    }

    protected int getMaxInputCount() {
        return 4;
    }

    protected int getMaxOutputCount() {
        return 16;
    }

    public static boolean canHandSift(Level world, ItemStack stack, ItemStack mesh, boolean waterlogged) {
        return SiftingRecipe.getMatchingInHandRecipes(world, stack, mesh, waterlogged);
    }

    public static List<ItemStack> applyHandSift(Level world, Vec3 position, ItemStack stack, ItemStack mesh, boolean waterlogged) {
        SifterInv inventoryIn = new SifterInv(stack, mesh);
        Optional<SiftingRecipe> recipe = ModRecipeTypes.SIFTING.find((Container)inventoryIn, world, waterlogged);
        if (recipe.isPresent()) {
            return recipe.get().rollResults();
        }
        return Collections.singletonList(stack);
    }

    public List<ItemStack> rollResults(List<ProcessingOutput> rollableResults) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < rollableResults.size(); ++i) {
            ProcessingOutput output = rollableResults.get(i);
            ItemStack stack = output.rollOutput();
            if (stack.m_41619_()) continue;
            results.add(stack);
        }
        return results;
    }

    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.waterlogged = GsonHelper.m_13855_((JsonObject)json, (String)"waterlogged", (boolean)false);
    }

    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        if (this.waterlogged) {
            json.addProperty("waterlogged", Boolean.valueOf(this.waterlogged));
        }
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.waterlogged = buffer.readBoolean();
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        buffer.writeBoolean(this.waterlogged);
    }

    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    public static boolean getMatchingInHandRecipes(Level world, ItemStack stack, ItemStack mesh, boolean waterlogged) {
        return ModRecipeTypes.SIFTING.find((Container)new SifterInv(stack, mesh), world, waterlogged).isPresent();
    }

    public boolean matches(RecipeWrapper pContainer, Level pLevel) {
        return this.matches(pContainer, pLevel, false);
    }

    public static class SifterInv
    extends RecipeWrapper {
        public SifterInv(ItemStack stack, ItemStack mesh) {
            super((IItemHandlerModifiable)new ItemStackHandler(2));
            this.inv.setStackInSlot(0, stack);
            this.inv.setStackInSlot(1, mesh);
        }
    }
}

