/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter;

import com.oierbravo.createsifter.ModRecipeTypes;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipe;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class SifterBlockEntity
extends KineticBlockEntity {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(9);
    public LazyOptional<IItemHandler> capability = LazyOptional.of(() -> new SifterInventoryHandler());
    public int timer;
    private SiftingRecipe lastRecipe;
    public ItemStackHandler meshInv = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return SiftingRecipe.isMeshItemStack(stack);
        }

        protected void onContentsChanged(int slot) {
            SifterBlockEntity.this.sendData();
        }
    };
    protected CombinedInvWrapper inputAndMeshCombined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInv, this.meshInv});
    protected int totalTime;

    public SifterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inputInv.getStackInSlot(0).m_41619_()) {
            return;
        }
        float pitch = Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        SoundScapes.play((SoundScapes.AmbienceGroup)SoundScapes.AmbienceGroup.MILLING, (BlockPos)this.f_58858_, (float)pitch);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).m_41613_() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.f_58857_.f_46443_) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).m_41619_()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputAndMeshCombined);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_, this.isWaterlogged())) {
            Optional<SiftingRecipe> recipe = ModRecipeTypes.SIFTING.find((Container)inventoryIn, this.f_58857_, this.isWaterlogged());
            if (!recipe.isPresent()) {
                this.timer = 100;
                this.totalTime = 100;
                this.sendData();
            } else {
                this.lastRecipe = recipe.get();
                this.timer = this.lastRecipe.getProcessingDuration();
                this.totalTime = this.lastRecipe.getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.getProcessingDuration();
        this.totalTime = this.lastRecipe.getProcessingDuration();
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    private void process() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputAndMeshCombined);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_, this.isWaterlogged())) {
            Optional<SiftingRecipe> recipe = ModRecipeTypes.SIFTING.find((Container)inventoryIn, this.f_58857_, this.isWaterlogged());
            if (!recipe.isPresent()) {
                return;
            }
            this.lastRecipe = recipe.get();
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.m_41774_(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        this.lastRecipe.rollResults().forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)stack, (boolean)false));
        this.sendData();
        this.m_6596_();
    }

    public void spawnParticles() {
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.m_41619_()) {
            return;
        }
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.f_123752_, stackInSlot);
        float angle = this.f_58857_.f_46441_.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y);
        Vec3 center = offset.m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)this.f_58857_.f_46441_, (float)0.0078125f);
        this.f_58857_.m_7106_((ParticleOptions)data, center.f_82479_, center.f_82480_, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Timer", this.timer);
        compound.m_128365_("InputInventory", (Tag)this.inputInv.serializeNBT());
        compound.m_128365_("OutputInventory", (Tag)this.outputInv.serializeNBT());
        compound.m_128365_("MeshInventory", (Tag)this.meshInv.serializeNBT());
        compound.m_128405_("TotalTime", this.totalTime);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.timer = compound.m_128451_("Timer");
        this.inputInv.deserializeNBT(compound.m_128469_("InputInventory"));
        this.outputInv.deserializeNBT(compound.m_128469_("OutputInventory"));
        this.meshInv.deserializeNBT(compound.m_128469_("MeshInventory"));
        this.totalTime = compound.m_128451_("TotalTime");
        super.read(compound, clientPacket);
    }

    public int getProcessingSpeed() {
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public float getProcessingRemainingPercent() {
        float timer = this.timer;
        float total = this.totalTime;
        float remaining = total - timer;
        float result = remaining / total;
        return 1.0f - result;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    private boolean canProcess(ItemStack stack) {
        ItemStackHandler tester = new ItemStackHandler(2);
        tester.setStackInSlot(0, stack);
        tester.setStackInSlot(1, this.meshInv.getStackInSlot(0));
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)tester);
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.f_58857_, this.isWaterlogged())) {
            return true;
        }
        return ModRecipeTypes.SIFTING.find((Container)inventoryIn, this.f_58857_, this.isWaterlogged()).isPresent();
    }

    public void insertMesh(ItemStack meshStack, Player player) {
        if (this.meshInv.getStackInSlot(0).m_41619_()) {
            ItemStack meshToInsert = meshStack.m_41777_();
            meshToInsert.m_41764_(1);
            meshStack.m_41774_(1);
            this.meshInv.setStackInSlot(0, meshToInsert);
            this.m_6596_();
        }
    }

    public boolean hasMesh() {
        return !this.meshInv.getStackInSlot(0).m_41619_();
    }

    public void removeMesh(Player player) {
        player.m_150109_().m_150079_(this.meshInv.getStackInSlot(0));
        this.meshInv.setStackInSlot(0, ItemStack.f_41583_);
    }

    public boolean isWaterlogged() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61362_);
    }

    public ItemStack getInputItemStack() {
        return this.inputInv.getStackInSlot(0);
    }

    private class SifterInventoryHandler
    extends CombinedInvWrapper {
        public SifterInventoryHandler() {
            super(new IItemHandlerModifiable[]{SifterBlockEntity.this.inputInv, SifterBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (SifterBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return SifterBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (SifterBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (SifterBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

