/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class ProcessingRecipeJSNoLiquid
extends RecipeJS {
    public List<ItemStack> outputItems;
    public List<ProcessingOutput> processingOutputs;
    public List<Ingredient> inputIngredients;

    public void create(RecipeArguments recipeArguments) {
        this.processingOutputs = this.parseProcessingOutputList(recipeArguments.get(0));
        this.inputIngredients = this.parseItemInputList(recipeArguments.get(1));
        this.json.addProperty("processingTime", (Number)100);
    }

    public ProcessingRecipeJSNoLiquid processingTime(int t) {
        this.json.addProperty("processingTime", (Number)t);
        this.save();
        return this;
    }

    public ProcessingRecipeJSNoLiquid waterlogged() {
        this.json.addProperty("waterlogged", Boolean.valueOf(true));
        this.save();
        return this;
    }

    public void deserialize() {
        this.inputIngredients = this.parseItemInputList(this.json.get("ingredients"));
        this.processingOutputs = this.parseProcessingOutputList(this.json.get("results"));
    }

    public void serialize() {
        if (this.serializeInputs) {
            JsonArray jsonIngredients = new JsonArray();
            for (Ingredient inputIngredient : this.inputIngredients) {
                jsonIngredients.add(inputIngredient.m_43942_());
            }
            this.json.add("ingredients", (JsonElement)jsonIngredients);
        }
        if (this.serializeOutputs) {
            JsonArray jsonOutputs = new JsonArray();
            for (ProcessingOutput item : this.processingOutputs) {
                jsonOutputs.add(item.serialize());
            }
            this.json.add("results", (JsonElement)jsonOutputs);
        }
    }

    public List<ProcessingOutput> parseProcessingOutputList(@Nullable Object o) {
        ArrayList<ProcessingOutput> list = new ArrayList<ProcessingOutput>();
        if (o instanceof JsonElement) {
            JsonArray jsonArray;
            JsonElement elem = (JsonElement)o;
            if (elem instanceof JsonArray) {
                JsonArray arr2 = (JsonArray)elem;
                jsonArray = arr2;
            } else {
                jsonArray = (JsonArray)Util.m_137469_((Object)new JsonArray(), arr -> arr.add(elem));
            }
            JsonArray array = jsonArray;
            for (JsonElement e : array) {
                list.add(this.parseProcessingOutput(e));
            }
        } else {
            for (Object o1 : ListJS.orSelf((Object)o)) {
                list.add(this.parseProcessingOutput(o1));
            }
        }
        return list;
    }

    public ProcessingOutput parseProcessingOutput(@Nullable Object o) {
        ProcessingOutput result = ProcessingOutput.EMPTY;
        if (o instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)o;
            JsonElement test = jsonObject.get("chance");
            float chance = 1.0f;
            if (jsonObject.has("chance")) {
                chance = jsonObject.get("chance").getAsFloat();
            }
            result = new ProcessingOutput(ItemStackJS.of((Object)o), chance);
        }
        if (result.getStack().m_41619_()) {
            throw new RecipeExceptionJS(o + " is not a valid result!");
        }
        return result;
    }

    public boolean hasInput(IngredientMatch ingredientMatch) {
        return false;
    }

    public boolean replaceInput(IngredientMatch ingredientMatch, Ingredient ingredient, ItemInputTransformer itemInputTransformer) {
        return false;
    }

    public boolean hasOutput(IngredientMatch ingredientMatch) {
        return false;
    }

    public boolean replaceOutput(IngredientMatch ingredientMatch, ItemStack itemStack, ItemOutputTransformer itemOutputTransformer) {
        return false;
    }
}

