/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.EnumSet;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityGenerator
extends TileEntityMekanism {
    private FloatingLong maxOutput;
    private BasicEnergyContainer energyContainer;

    public TileEntityGenerator(IBlockProvider blockProvider, BlockPos pos, BlockState state, @NotNull FloatingLongSupplier maxOutput) {
        super(blockProvider, pos, state);
        this.updateMaxOutputRaw(maxOutput.get());
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIG_CARD, (Object)((Object)this)));
    }

    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.FRONT};
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((TileEntityGenerator)this).getDirection());
        this.energyContainer = BasicEnergyContainer.output((FloatingLong)MachineEnergyContainer.validateBlock((TileEntityMekanism)this).getStorage(), (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer, this.getEnergySides());
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        if (MekanismUtils.canFunction((TileEntityMekanism)this)) {
            EnumSet<Direction> emitDirections = EnumSet.noneOf(Direction.class);
            Direction direction = this.getDirection();
            for (RelativeSide energySide : this.getEnergySides()) {
                emitDirections.add(energySide.getDirection(direction));
            }
            CableUtils.emit(emitDirections, (IEnergyContainer)this.energyContainer, (BlockEntity)this, (FloatingLong)this.getMaxOutput());
        }
    }

    @ComputerMethod
    public FloatingLong getMaxOutput() {
        return this.maxOutput;
    }

    protected void updateMaxOutputRaw(FloatingLong maxOutput) {
        this.maxOutput = maxOutput.multiply(2L);
    }

    protected ISyncableData syncableMaxOutput() {
        return SyncableFloatingLong.create(this::getMaxOutput, value -> {
            this.maxOutput = value;
        });
    }

    public BasicEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }
}

