/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.nio.FloatBuffer;
import jeresources.api.render.IMobRenderHook;
import jeresources.api.render.IScissorHook;
import jeresources.compatibility.api.MobRegistryImpl;
import jeresources.reference.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static void drawLine(PoseStack poseStack, int xBegin, int yBegin, int xEnd, int yEnd, int color) {
        GuiComponent.m_93172_((PoseStack)poseStack, (int)xBegin, (int)yBegin, (int)(xEnd += xBegin == xEnd ? 1 : 0), (int)(yEnd += yBegin == yEnd ? 1 : 0), (int)color);
    }

    public static void renderEntity(PoseStack poseStack, int x, int y, double scale, double yaw, double pitch, LivingEntity livingEntity) {
        if (livingEntity.f_19853_ == null) {
            livingEntity.f_19853_ = Minecraft.m_91087_().f_91073_;
        }
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(poseStack.m_85850_().m_85861_());
        modelViewStack.m_85837_((double)x, (double)y, 50.0);
        modelViewStack.m_85841_((float)(-scale), (float)scale, (float)scale);
        PoseStack mobPoseStack = new PoseStack();
        mobPoseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        IMobRenderHook.RenderInfo renderInfo = MobRegistryImpl.applyRenderHooks(livingEntity, new IMobRenderHook.RenderInfo(x, y, scale, yaw, pitch));
        x = renderInfo.x;
        y = renderInfo.y;
        scale = renderInfo.scale;
        yaw = renderInfo.yaw;
        pitch = renderInfo.pitch;
        mobPoseStack.m_85845_(Vector3f.f_122222_.m_122240_((float)Math.atan(pitch / 40.0) * 20.0f));
        livingEntity.f_19855_ = (float)Math.atan(yaw / 40.0) * 20.0f;
        float yRot = (float)Math.atan(yaw / 40.0) * 40.0f;
        float xRot = -((float)Math.atan(pitch / 40.0)) * 20.0f;
        livingEntity.m_146922_(yRot);
        livingEntity.m_146922_(yRot);
        livingEntity.m_146926_(xRot);
        livingEntity.f_20885_ = yRot;
        livingEntity.f_20886_ = yRot;
        mobPoseStack.m_85837_(0.0, livingEntity.m_20186_(), 0.0);
        RenderSystem.m_157182_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, mobPoseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void renderChest(PoseStack poseStack, float x, float y, float rotate, float scale, float lidAngle) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Resources.Vanilla.CHEST);
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85837_((double)x, (double)y, 50.0);
        poseStack.m_85845_(new Quaternion(-160.0f, 1.0f, 0.0f, 0.0f));
        poseStack.m_85841_(scale, -scale, -scale);
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(new Quaternion(rotate, 0.0f, 1.0f, 0.0f));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        float lidAngleF = lidAngle / 180.0f;
        lidAngleF = 1.0f - lidAngleF;
        lidAngleF = 1.0f - lidAngleF * lidAngleF * lidAngleF;
        poseStack.m_85849_();
    }

    public static void renderBlock(PoseStack poseStack, BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(-scale, -scale, -scale);
        poseStack.m_85837_(-0.5, -0.5, 0.0);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-30.0f));
        poseStack.m_85837_(0.5, 0.0, -0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotate));
        poseStack.m_85837_(-0.5, 0.0, 0.5);
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85837_(0.0, 0.0, -1.0);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        mc.m_91289_().m_110912_(block, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public static void scissor(PoseStack poseStack, int x, int y, int w, int h) {
        double scale = Minecraft.m_91087_().m_91268_().m_85449_();
        double[] xyzTranslation = RenderHelper.getGLTranslation(poseStack, scale);
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        w = (int)((double)w * scale);
        h = (int)((double)h * scale);
        int scissorX = Math.round(Math.round(xyzTranslation[0] + (double)x));
        int scissorY = Math.round(Math.round((double)(Minecraft.m_91087_().m_91268_().m_85442_() - y - h) - xyzTranslation[1]));
        int scissorW = Math.round(w);
        int scissorH = Math.round(h);
        IScissorHook.ScissorInfo scissorInfo = MobRegistryImpl.applyScissorHooks(new IScissorHook.ScissorInfo(scissorX, scissorY, scissorW, scissorH));
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorInfo.x, (int)scissorInfo.y, (int)scissorInfo.width, (int)scissorInfo.height);
    }

    public static void stopScissor() {
        GL11.glDisable((int)3089);
    }

    public static void drawTexture(PoseStack poseStack, int x, int y, int u, int v, int width, int height, ResourceLocation resource) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        RenderHelper.drawTexturedModalRect(poseStack, x, y, u, v, width, height, 0.0f);
    }

    public static double[] getGLTranslation(PoseStack poseStack, double scale) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        matrix.m_27650_(buf);
        return new double[]{(double)buf.get(RenderHelper.getIndexFloatBuffer(0, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(1, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(2, 3)) * scale};
    }

    private static int getIndexFloatBuffer(int x, int y) {
        return y * 4 + x;
    }

    public static double getGuiScaleFactor() {
        return Minecraft.m_91087_().m_91268_().m_85449_();
    }

    public static void drawTexturedModalRect(PoseStack poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder wr = tesselator.m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        wr.m_85982_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_85982_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_85982_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        wr.m_85982_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        tesselator.m_85914_();
    }
}

