/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.container.AmountContainerMenu;
import com.refinedmods.refinedstorage.network.SetFilterSlotMessage;
import com.refinedmods.refinedstorage.screen.AmountSpecifyingScreen;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemAmountScreen
extends AmountSpecifyingScreen<AmountContainerMenu> {
    private final int containerSlot;
    private final ItemStack stack;
    private final int maxAmount;
    @Nullable
    private final UnaryOperator<Screen> alternativesScreenFactory;

    public ItemAmountScreen(BaseScreen parent, Player player, int containerSlot, ItemStack stack, int maxAmount, @Nullable UnaryOperator<Screen> alternativesScreenFactory) {
        super(parent, new AmountContainerMenu(player, stack), alternativesScreenFactory != null ? 194 : 172, 99, player.m_150109_(), (Component)Component.m_237115_((String)"gui.refinedstorage.item_amount"));
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
        this.alternativesScreenFactory = alternativesScreenFactory;
    }

    @Override
    protected int getOkCancelButtonWidth() {
        return this.alternativesScreenFactory != null ? 75 : super.getOkCancelButtonWidth();
    }

    @Override
    public void onPostInit(int x, int y) {
        super.onPostInit(x, y);
        if (this.alternativesScreenFactory != null) {
            this.addButton(x + 114, this.cancelButton.f_93621_ + 24, this.getOkCancelButtonWidth(), 20, (Component)Component.m_237115_((String)"gui.refinedstorage.alternatives"), true, true, btn -> this.f_96541_.m_91152_((Screen)this.alternativesScreenFactory.apply((Screen)this)));
        }
    }

    @Override
    protected Pair<Integer, Integer> getOkCancelPos() {
        if (this.alternativesScreenFactory == null) {
            return super.getOkCancelPos();
        }
        return Pair.of((Object)114, (Object)22);
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack.m_41613_();
    }

    @Override
    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    protected int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    protected Component getOkButtonText() {
        return Component.m_237115_((String)"misc.refinedstorage.set");
    }

    @Override
    protected String getTexture() {
        return this.alternativesScreenFactory != null ? "gui/amount_specifying_wide.png" : "gui/amount_specifying.png";
    }

    @Override
    protected int[] getIncrements() {
        return new int[]{1, 10, 64, -1, -10, -64};
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int amount = Integer.parseInt(this.amountField.m_94155_());
            RS.NETWORK_HANDLER.sendToServer(new SetFilterSlotMessage(this.containerSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)amount)));
            this.close();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

