/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.blockentity;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Vector3f;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.block.StorageMonitorBlock;
import com.refinedmods.refinedstorage.blockentity.StorageMonitorBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.util.TransformationHelper;
import net.minecraftforge.fluids.FluidStack;

public class StorageMonitorBlockEntityRenderer
implements BlockEntityRenderer<StorageMonitorBlockEntity> {
    public void render(StorageMonitorBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int i, int i1) {
        Direction direction = Direction.NORTH;
        BlockState state = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_());
        if (state.m_60734_() instanceof StorageMonitorBlock) {
            direction = (Direction)state.m_61143_((Property)((StorageMonitorBlock)((Object)RSBlocks.STORAGE_MONITOR.get())).getDirection().getProperty());
        }
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_().m_121955_(direction.m_122436_()));
        float rotation = (float)(Math.PI * (double)(360 - direction.m_122424_().m_122416_() * 90) / 180.0);
        int type = blockEntity.getStackType();
        ItemStack itemStack = blockEntity.getItemStack();
        FluidStack fluidStack = blockEntity.getFluidStack();
        if (type == 0 && itemStack != null && !itemStack.m_41619_()) {
            this.renderItem(poseStack, renderTypeBuffer, direction, rotation, light, itemStack);
            String amount = API.instance().getQuantityFormatter().formatWithUnits(blockEntity.getAmount());
            this.renderText(poseStack, renderTypeBuffer, direction, rotation, light, amount);
        } else if (type == 1 && fluidStack != null && !fluidStack.isEmpty()) {
            this.renderFluid(poseStack, renderTypeBuffer, direction, rotation, light, fluidStack);
            String amount = API.instance().getQuantityFormatter().formatInBucketFormWithOnlyTrailingDigitsIfZero(blockEntity.getAmount());
            this.renderText(poseStack, renderTypeBuffer, direction, rotation, light, amount);
        }
    }

    private void renderText(PoseStack poseStack, MultiBufferSource renderTypeBuffer, Direction direction, float rotation, int light, String amount) {
        poseStack.m_85836_();
        float stringOffset = -((float)Minecraft.m_91087_().f_91062_.m_92895_(amount) * 0.01f) / 2.0f;
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85837_((double)((float)direction.m_122429_() * 0.501f + (float)direction.m_122431_() * stringOffset), -0.275, (double)((float)direction.m_122431_() * 0.501f - (float)direction.m_122429_() * stringOffset));
        poseStack.m_85845_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f((float)(direction.m_122429_() * 180), 0.0f, (float)(direction.m_122431_() * 180)), (boolean)true));
        poseStack.m_85845_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, rotation, 0.0f), (boolean)false));
        poseStack.m_85841_(0.01f, 0.01f, 0.01f);
        Minecraft.m_91087_().f_91062_.m_92811_(amount, 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_85861_(), renderTypeBuffer, false, 0, light);
        poseStack.m_85849_();
    }

    private void renderItem(PoseStack poseStack, MultiBufferSource renderTypeBuffer, Direction direction, float rotation, int light, ItemStack itemStack) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85837_((double)((float)direction.m_122429_() * 0.501f), 0.0, (double)((float)direction.m_122431_() * 0.501f));
        poseStack.m_85845_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, rotation, 0.0f), (boolean)false));
        poseStack.m_85841_(0.5f, -0.5f, -5.0E-5f);
        poseStack.m_85845_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, 0.0f, 180.0f), (boolean)true));
        BakedModel itemModel = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, null, null, 0);
        boolean render3D = itemModel.m_7539_();
        if (render3D) {
            Lighting.m_84931_();
        } else {
            Lighting.m_84930_();
        }
        poseStack.m_85850_().m_85864_().m_8169_(Matrix3f.m_8174_((float)1.0f, (float)-1.0f, (float)1.0f));
        Minecraft.m_91087_().m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, renderTypeBuffer, light, OverlayTexture.f_118083_, itemModel);
        poseStack.m_85849_();
    }

    private void renderFluid(PoseStack poseStack, MultiBufferSource renderTypeBuffer, Direction direction, float rotation, int light, FluidStack fluidStack) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85837_((double)((float)direction.m_122429_() * 0.51f), 0.5, (double)((float)direction.m_122431_() * 0.51f));
        poseStack.m_85845_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, rotation, 0.0f), (boolean)false));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
        int fluidColor = attributes.getTintColor(fluidStack);
        VertexConsumer buffer = renderTypeBuffer.m_6299_(RenderType.m_110497_((ResourceLocation)sprite.m_118414_().m_118330_()));
        int colorRed = fluidColor >> 16 & 0xFF;
        int colorGreen = fluidColor >> 8 & 0xFF;
        int colorBlue = fluidColor & 0xFF;
        int colorAlpha = fluidColor >> 24 & 0xFF;
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), -0.5f, -0.5f, 0.0f).m_6122_(colorRed, colorGreen, colorBlue, colorAlpha).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(light).m_5752_();
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), 0.5f, -0.5f, 0.0f).m_6122_(colorRed, colorGreen, colorBlue, colorAlpha).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(light).m_5752_();
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), 0.5f, -1.5f, 0.0f).m_6122_(colorRed, colorGreen, colorBlue, colorAlpha).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(light).m_5752_();
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), -0.5f, -1.5f, 0.0f).m_6122_(colorRed, colorGreen, colorBlue, colorAlpha).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(light).m_5752_();
        poseStack.m_85849_();
    }
}

