/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.container.GridContainerMenu;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class GridItemGridScrollMessage {
    private final UUID id;
    private final boolean shift;
    private final boolean up;

    public GridItemGridScrollMessage(@Nullable UUID id, boolean shift, boolean up) {
        this.id = id;
        this.shift = shift;
        this.up = up;
    }

    public static GridItemGridScrollMessage decode(FriendlyByteBuf buf) {
        return new GridItemGridScrollMessage(buf.readBoolean() ? buf.m_130259_() : null, buf.readBoolean(), buf.readBoolean());
    }

    public static void encode(GridItemGridScrollMessage message, FriendlyByteBuf buf) {
        boolean hasId = message.id != null;
        buf.writeBoolean(hasId);
        if (hasId) {
            buf.m_130077_(message.id);
        }
        buf.writeBoolean(message.shift);
        buf.writeBoolean(message.up);
    }

    public static void handle(GridItemGridScrollMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && player.f_36096_ instanceof GridContainerMenu && ((GridContainerMenu)player.f_36096_).getGrid().getItemHandler() != null) {
                ((GridContainerMenu)player.f_36096_).getGrid().getItemHandler().onGridScroll(player, message.id, message.shift, message.up);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

