/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.api.util.IStackList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IGrid {
    public static final int TABS_PER_PAGE = 5;
    public static final int SORTING_DIRECTION_ASCENDING = 0;
    public static final int SORTING_DIRECTION_DESCENDING = 1;
    public static final int SORTING_TYPE_QUANTITY = 0;
    public static final int SORTING_TYPE_NAME = 1;
    public static final int SORTING_TYPE_ID = 2;
    public static final int SORTING_TYPE_INVENTORYTWEAKS = 3;
    public static final int SORTING_TYPE_LAST_MODIFIED = 4;
    public static final int SEARCH_BOX_MODE_NORMAL = 0;
    public static final int SEARCH_BOX_MODE_NORMAL_AUTOSELECTED = 1;
    public static final int SEARCH_BOX_MODE_JEI_SYNCHRONIZED = 2;
    public static final int SEARCH_BOX_MODE_JEI_SYNCHRONIZED_AUTOSELECTED = 3;
    public static final int SEARCH_BOX_MODE_JEI_SYNCHRONIZED_2WAY = 4;
    public static final int SEARCH_BOX_MODE_JEI_SYNCHRONIZED_2WAY_AUTOSELECTED = 5;
    public static final int VIEW_TYPE_NORMAL = 0;
    public static final int VIEW_TYPE_NON_CRAFTABLES = 1;
    public static final int VIEW_TYPE_CRAFTABLES = 2;
    public static final int SIZE_STRETCH = 0;
    public static final int SIZE_SMALL = 1;
    public static final int SIZE_MEDIUM = 2;
    public static final int SIZE_LARGE = 3;

    public static boolean isValidViewType(int type) {
        return type == 0 || type == 2 || type == 1;
    }

    public static boolean isValidSearchBoxMode(int mode) {
        return mode == 0 || mode == 1 || mode == 2 || mode == 3 || mode == 4 || mode == 5;
    }

    public static boolean isSearchBoxModeWithAutoselection(int mode) {
        return mode == 1 || mode == 3 || mode == 5;
    }

    public static boolean doesSearchBoxModeUseJEI(int mode) {
        return mode == 2 || mode == 3 || mode == 4 || mode == 5;
    }

    public static boolean isValidSortingType(int type) {
        return type == 0 || type == 1 || type == 2 || type == 3 || type == 4;
    }

    public static boolean isValidSortingDirection(int direction) {
        return direction == 0 || direction == 1;
    }

    public static boolean isValidSize(int size) {
        return size == 0 || size == 1 || size == 2 || size == 3;
    }

    public GridType getGridType();

    public IStorageCacheListener createListener(ServerPlayer var1);

    @Nullable
    public IStorageCache getStorageCache();

    @Nullable
    public IItemGridHandler getItemHandler();

    @Nullable
    public IFluidGridHandler getFluidHandler();

    default public void addCraftingListener(ICraftingGridListener listener) {
    }

    default public void removeCraftingListener(ICraftingGridListener listener) {
    }

    public Component getTitle();

    public int getViewType();

    public int getSortingType();

    public int getSortingDirection();

    public int getSearchBoxMode();

    public int getTabSelected();

    public int getTabPage();

    public int getTotalTabPages();

    public int getSize();

    public void onViewTypeChanged(int var1);

    public void onSortingTypeChanged(int var1);

    public void onSortingDirectionChanged(int var1);

    public void onSearchBoxModeChanged(int var1);

    public void onSizeChanged(int var1);

    public void onTabSelectionChanged(int var1);

    public void onTabPageChanged(int var1);

    public List<IFilter> getFilters();

    public List<IGridTab> getTabs();

    public IItemHandlerModifiable getFilter();

    @Nullable
    public CraftingContainer getCraftingMatrix();

    @Nullable
    public ResultContainer getCraftingResult();

    public void onCraftingMatrixChanged();

    public void onCrafted(Player var1, @Nullable IStackList<ItemStack> var2, @Nullable IStackList<ItemStack> var3);

    public void onClear(Player var1);

    public void onCraftedShift(Player var1);

    public void onRecipeTransfer(Player var1, ItemStack[][] var2);

    public void onClosed(Player var1);

    public boolean isGridActive();

    public int getSlotId();
}

