/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import ky.someone.mods.gag.GAG;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.entity.EntityTypeRegistry;
import ky.someone.mods.gag.entity.TimeAcceleratorEntity;
import ky.someone.mods.gag.item.GAGItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TemporalPouchItem
extends GAGItem {
    public static final String GRAINS_NBT_KEY = "grains";
    public static final String TIAB_STORED_KEY = "storedTime";
    public static TagKey<BlockEntityType<?>> DO_NOT_ACCELERATE = TagKey.m_203882_((ResourceKey)Registry.f_122907_, (ResourceLocation)GAGUtil.id("do_not_accelerate"));

    public TemporalPouchItem() {
        super(new Item.Properties().m_41491_(GAG.CREATIVE_TAB).m_41487_(1));
    }

    public static int getStoredGrains(ItemStack stack) {
        return stack.m_41784_().m_128451_(GRAINS_NBT_KEY);
    }

    public static void setStoredGrains(ItemStack stack, int time) {
        int newStoredTime = Math.min(time, (Integer)GAGConfig.SandsOfTime.POUCH_CAPACITY.get());
        stack.m_41784_().m_128405_(GRAINS_NBT_KEY, newStoredTime);
    }

    public void m_142312_(CompoundTag tag) {
        super.m_142312_(tag);
        if (!Platform.isModLoaded((String)"tiab") && tag.m_128441_(TIAB_STORED_KEY)) {
            tag.m_128405_(GRAINS_NBT_KEY, tag.m_128451_(TIAB_STORED_KEY));
            tag.m_128473_(TIAB_STORED_KEY);
        }
    }

    public MutableComponent getTimeForDisplay(ItemStack stack) {
        int storedGrains = TemporalPouchItem.getStoredGrains(stack);
        int seconds = storedGrains * (Integer)GAGConfig.SandsOfTime.DURATION_PER_USE.get() / (Integer)GAGConfig.SandsOfTime.GRAINS_USED.get();
        int minutes = seconds / 60;
        int hours = seconds / 3600;
        String timeString = String.format("%ds", seconds);
        if (hours > 0) {
            timeString = String.format("%dh %dm %ds", hours, minutes % 60, seconds % 60);
        } else if (minutes > 0) {
            timeString = String.format("%dm %ds", minutes, seconds % 60);
        }
        return Component.m_237110_((String)"item.gag.time_sand_pouch.info.stored_grains", (Object[])new Object[]{storedGrains, timeString});
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        int storedGrains;
        Player player;
        super.m_6883_(stack, level, entity, itemSlot, isSelected);
        if (level.f_46443_ || !(entity instanceof Player) || PlayerHooks.isFake((Player)(player = (Player)entity))) {
            return;
        }
        if (level.m_46467_() % 20L == 0L && (storedGrains = TemporalPouchItem.getStoredGrains(stack)) + 20 < (Integer)GAGConfig.SandsOfTime.POUCH_CAPACITY.get()) {
            TemporalPouchItem.setStoredGrains(stack, storedGrains + 20);
        }
        if (level.m_46467_() % 200L == 0L && TemporalPouchItem.getStoredGrains(stack) != 0) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack invStack = player.m_150109_().m_8020_(i);
                if (invStack.m_41720_() != this || invStack == stack) continue;
                int otherTimeData = TemporalPouchItem.getStoredGrains(invStack);
                int myTimeData = TemporalPouchItem.getStoredGrains(stack);
                if (myTimeData < otherTimeData) {
                    TemporalPouchItem.setStoredGrains(stack, 0);
                    continue;
                }
                TemporalPouchItem.setStoredGrains(invStack, 0);
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        boolean validBlockEntity = Optional.ofNullable(level.m_7702_(pos)).map(BlockEntity::m_58903_).flatMap(arg_0 -> ((Registry)Registry.f_122830_).m_7854_(arg_0)).flatMap(arg_0 -> ((Registry)Registry.f_122830_).m_203636_(arg_0)).filter(type -> !type.m_203656_(DO_NOT_ACCELERATE)).isPresent();
        boolean randomTickingState = level.m_8055_(pos).m_60823_();
        if (!(GAGConfig.SandsOfTime.isLevelAllowed(level) && (validBlockEntity || ((Boolean)GAGConfig.SandsOfTime.ALLOW_RANDOM_TICKS.get()).booleanValue() && randomTickingState))) {
            return InteractionResult.FAIL;
        }
        int baseDuration = 20 * (Integer)GAGConfig.SandsOfTime.DURATION_PER_USE.get();
        TimeAcceleratorEntity accelerator = level.m_45976_(TimeAcceleratorEntity.class, new AABB(pos)).stream().findFirst().orElse(null);
        if (accelerator == null) {
            if (this.shouldDamage(player, stack) && TemporalPouchItem.getStoredGrains(stack) < this.grainsRequired(1)) {
                return InteractionResult.SUCCESS;
            }
            accelerator = Objects.requireNonNull((TimeAcceleratorEntity)((EntityType)EntityTypeRegistry.TIME_ACCELERATOR.get()).m_20615_(level));
            accelerator.m_146884_(Vec3.m_82512_((Vec3i)pos));
            accelerator.setTicksRemaining(baseDuration);
            level.m_7967_((Entity)accelerator);
        }
        int clicks = accelerator.getTimesAccelerated();
        if (clicks++ >= (Integer)GAGConfig.SandsOfTime.MAX_RATE.get() || this.shouldDamage(player, stack) && TemporalPouchItem.getStoredGrains(stack) < this.grainsRequired(clicks)) {
            return InteractionResult.SUCCESS;
        }
        accelerator.setTimesAccelerated(clicks);
        accelerator.setTicksRemaining((accelerator.getTicksRemaining() + baseDuration) / 2);
        if (this.shouldDamage(player, stack)) {
            TemporalPouchItem.setStoredGrains(stack, TemporalPouchItem.getStoredGrains(stack) - this.grainsRequired(clicks));
        }
        this.playNote(level, pos, clicks);
        return InteractionResult.SUCCESS;
    }

    public int grainsRequired(int level) {
        return (1 << Math.max(0, level - 1)) * (Integer)GAGConfig.SandsOfTime.GRAINS_USED.get();
    }

    private void playNote(Level level, BlockPos pos, int rate) {
        int[] pitches = new int[]{-6, -4, -2, -1, 1, 3, 5, 6};
        float pitch = (float)Math.pow(2.0, (double)pitches[(rate - 1) % 8] / 12.0);
        level.m_5594_(null, pos, rate > 8 ? SoundEvents.f_12212_ : SoundEvents.f_12211_, SoundSource.PLAYERS, 3.0f, pitch);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"(Note: This item is subject to change in the future,").m_130938_(GAGUtil.COLOUR_TRUE));
        tooltip.add((Component)Component.m_237115_((String)"currently it just works like a Time in A Bottle!)").m_130938_(GAGUtil.COLOUR_TRUE));
        GAGUtil.appendInfoTooltip(tooltip, List.of(Component.m_237115_((String)"item.gag.time_sand_pouch.info.1").m_130938_(GAGUtil.TOOLTIP_MAIN), Component.m_237115_((String)"item.gag.time_sand_pouch.info.2").m_130938_(GAGUtil.TOOLTIP_MAIN)));
        float hue = level == null ? 0.0f : (float)level.m_46467_() % 1200.0f;
        tooltip.add((Component)this.getTimeForDisplay(stack).m_130938_(style -> style.m_178520_(Mth.m_14169_((float)(hue / 1200.0f), (float)1.0f, (float)1.0f))));
    }

    @Override
    public boolean shouldBob(ItemStack oldStack, ItemStack newStack) {
        return false;
    }
}

