/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.block.BlockRegistry;
import ky.someone.mods.gag.client.render.TimeAcceleratorEntityRenderer;
import ky.someone.mods.gag.client.screen.LabelingMenuScreen;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.entity.EntityTypeRegistry;
import ky.someone.mods.gag.entity.TimeAcceleratorEntity;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.menu.MenuTypeRegistry;
import ky.someone.mods.gag.particle.ParticleTypeRegistry;
import ky.someone.mods.gag.particle.client.MagicParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface GAGClient {
    public static final Screen DUMMY_SCREEN = new Screen((Component)Component.m_237119_()){};

    public static void init() {
        GAGClient.registerEntityRenderers();
        ClientLifecycleEvent.CLIENT_SETUP.register(GAGClient::setup);
        ClientLifecycleEvent.CLIENT_STARTED.register(GAGClient::clientDone);
        ClientGuiEvent.RENDER_HUD.register(GAGClient::renderHUD);
        ParticleProviderRegistry.register(ParticleTypeRegistry.MAGIC, MagicParticle.Provider::new);
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityTypeRegistry.TIME_ACCELERATOR, TimeAcceleratorEntityRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.MINING_DYNAMITE, ThrownItemRenderer::new);
    }

    public static void renderHUD(PoseStack poseStack, float partialTicks) {
        Item item;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91066_.f_92062_ || minecraft.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        ClientLevel level = minecraft.f_91073_;
        LocalPlayer player = minecraft.f_91074_;
        if (level == null || player == null) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockPos pos = blockHit.m_82425_();
            Block block = level.m_8055_(pos).m_60734_();
            TimeAcceleratorEntity accelerator = (TimeAcceleratorEntity)((Object)Iterables.getFirst((Iterable)level.m_45976_(TimeAcceleratorEntity.class, new AABB(pos)), null));
            if (accelerator != null) {
                int accelSpeed = accelerator.getTimesAccelerated();
                double timeLeft = (double)accelerator.getTicksRemaining() / 20.0;
                if (accelSpeed == 0) {
                    return;
                }
                GAGClient.renderHudTooltip(poseStack, List.of(block.m_49954_(), Component.m_237110_((String)"info.gag.time_sand_tooltip_mult", (Object[])new Object[]{GAGUtil.asStyledValue(accelSpeed, ((Integer)GAGConfig.SandsOfTime.MAX_RATE.get()).intValue(), Integer.toString(1 << accelSpeed))}), Component.m_237110_((String)"info.gag.time_sand_tooltip_time", (Object[])new Object[]{GAGUtil.asStyledValue(timeLeft, ((Integer)GAGConfig.SandsOfTime.DURATION_PER_USE.get()).intValue(), String.format("%.2f", timeLeft))})));
                return;
            }
        }
        ItemStack stack = player.m_21211_();
        List<Object> tooltip = List.of();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof GAGItem) {
            GAGItem item2 = (GAGItem)item;
            tooltip = item2.getUsingTooltip((Player)player, stack, player.m_21252_());
        } else {
            stack = player.m_21205_();
            item = stack.m_41720_();
            if (item instanceof GAGItem) {
                GAGItem item3 = (GAGItem)item;
                tooltip = item3.getHoldingTooltip((Player)player, stack);
            } else {
                stack = player.m_21206_();
                item = stack.m_41720_();
                if (item instanceof GAGItem) {
                    GAGItem item4 = (GAGItem)item;
                    tooltip = item4.getHoldingTooltip((Player)player, stack);
                }
            }
        }
        if (!tooltip.isEmpty()) {
            GAGClient.renderHudTooltip(poseStack, tooltip);
        }
    }

    private static void renderHudTooltip(PoseStack poseStack, List<Component> text) {
        Minecraft mc = Minecraft.m_91087_();
        GAGClient.DUMMY_SCREEN.f_96543_ = mc.m_91268_().m_85445_();
        int x = GAGClient.DUMMY_SCREEN.f_96543_ / 2;
        GAGClient.DUMMY_SCREEN.f_96544_ = mc.m_91268_().m_85446_();
        int y = GAGClient.DUMMY_SCREEN.f_96544_ / 2;
        DUMMY_SCREEN.m_96597_(poseStack, text, x + 10, y);
    }

    public static void setup(Minecraft minecraft) {
        RenderTypeRegistry.register((RenderType)RenderType.m_110457_(), (Block[])new Block[]{(Block)BlockRegistry.NO_SOLICITORS_SIGN.get()});
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypeRegistry.LABELING.get()), LabelingMenuScreen::new);
    }

    public static void clientDone(Minecraft minecraft) {
        DUMMY_SCREEN.m_6575_(minecraft, minecraft.m_91268_().m_85445_(), minecraft.m_91268_().m_85446_());
    }
}

