/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.dimension.Dimension;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class DimensionUtil {
    public static void createAndRegisterWorldAndDimension(MinecraftServer server) {
        Map map = server.forgeGetWorldMap();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)Dimension.COMPACT_DIMENSION.m_135782_());
        ResourceManager serverResources = server.m_177941_();
        if (FMLEnvironment.production && !DimensionUtil.doLevelFileBackup(server)) {
            return;
        }
        RegistryAccess.Frozen reg = server.m_206579_();
        DimensionType cmDimType = (DimensionType)reg.m_175515_(Registry.f_122818_).m_6246_(Dimension.COMPACT_DIMENSION_DIM_TYPE);
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)reg);
        RegistryResourceAccess resourceAccess = RegistryResourceAccess.m_195881_((ResourceManager)serverResources);
        Map dims = resourceAccess.m_214030_(Registry.f_122819_);
    }

    public static boolean doLevelFileBackup(MinecraftServer server) {
        Path levelRoot = server.m_129843_(LevelResource.f_78182_);
        Path levelFile = server.m_129843_(LevelResource.f_78178_);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("'cm4-dimension-'yyyyMMdd-HHmmss'.dat'");
        String timestamp = formatter.format(ZonedDateTime.now());
        try {
            Files.copy(levelFile, levelRoot.resolve(timestamp), new CopyOption[0]);
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error("Failed to backup dimension.dat file before modification; canceling register dim attempt.");
            return false;
        }
        return true;
    }
}

