/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel.definitions;

import com.google.common.collect.ImmutableSet;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.capability.CapabilityTunnel;
import dev.compactmods.machines.api.tunnels.lifecycle.TunnelInstance;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.FastColor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyTunnel
implements TunnelDefinition,
CapabilityTunnel<Instance> {
    @Override
    public int ringColor() {
        return FastColor.ARGB32.m_13660_((int)255, (int)0, (int)166, (int)88);
    }

    @Override
    public ImmutableSet<Capability<?>> getSupportedCapabilities() {
        return ImmutableSet.of((Object)CapabilityEnergy.ENERGY);
    }

    @Override
    public <CapType> LazyOptional<CapType> getCapability(Capability<CapType> type, Instance instance) {
        if (type == CapabilityEnergy.ENERGY) {
            return instance.lazy().cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public Instance newInstance(BlockPos position, Direction side) {
        return new Instance();
    }

    public static class Instance
    implements TunnelInstance,
    INBTSerializable<CompoundTag> {
        private final int DEFAULT_STORAGE = 10000;
        private EnergyStorage storage = new EnergyStorage(10000);
        private final LazyOptional<IEnergyStorage> lazy = LazyOptional.of(this::getStorage);

        @Nonnull
        public EnergyStorage getStorage() {
            return this.storage;
        }

        public LazyOptional<IEnergyStorage> lazy() {
            return this.lazy;
        }

        public CompoundTag serializeNBT() {
            CompoundTag data = new CompoundTag();
            data.m_128365_("storage", this.storage.serializeNBT());
            return data;
        }

        public void deserializeNBT(CompoundTag nbt) {
            if (!nbt.m_128441_("storage")) {
                this.storage = new EnergyStorage(10000);
                return;
            }
            Tag stor = nbt.m_128423_("storage");
            this.storage.deserializeNBT(stor);
        }
    }
}

