/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.CMTags;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.api.room.RoomSize;
import dev.compactmods.machines.api.room.upgrade.RoomUpgrade;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.dimension.MissingDimensionException;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.location.PreciseDimensionalPosition;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.machine.CompactMachineItem;
import dev.compactmods.machines.machine.EnumMachinePlayersBreakHandling;
import dev.compactmods.machines.machine.Machines;
import dev.compactmods.machines.machine.graph.DimensionMachineGraph;
import dev.compactmods.machines.room.RoomCapabilities;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import dev.compactmods.machines.room.history.PlayerRoomHistoryItem;
import dev.compactmods.machines.room.menu.MachineRoomMenu;
import dev.compactmods.machines.shrinking.Shrinking;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import dev.compactmods.machines.upgrade.MachineRoomUpgrades;
import dev.compactmods.machines.upgrade.RoomUpgradeItem;
import dev.compactmods.machines.upgrade.RoomUpgradeManager;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.IForgeRegistry;

public class CompactMachineBlock
extends Block
implements EntityBlock {
    public static final TagKey<Block> TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("compactmachines", "machine"));
    private final RoomSize size;

    public CompactMachineBlock(RoomSize size, BlockBehaviour.Properties props) {
        super(props);
        this.size = size;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        CompactMachineBlockEntity tile = (CompactMachineBlockEntity)worldIn.m_7702_(pos);
        float normalHardness = super.m_5880_(state, player, worldIn, pos);
        if (tile == null) {
            return normalHardness;
        }
        boolean hasPlayers = tile.hasPlayersInside();
        if (hasPlayers) {
            EnumMachinePlayersBreakHandling hand = (EnumMachinePlayersBreakHandling)((Object)ServerConfig.MACHINE_PLAYER_BREAK_HANDLING.get());
            switch (hand) {
                case UNBREAKABLE: {
                    return 0.0f;
                }
                case OWNER: {
                    Optional<UUID> ownerUUID = tile.getOwnerUUID();
                    return ownerUUID.map(uuid -> Float.valueOf(player.m_20148_() == uuid ? normalHardness : 0.0f)).orElse(Float.valueOf(normalHardness)).floatValue();
                }
                case ANYONE: {
                    return normalHardness;
                }
            }
        }
        return normalHardness;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return false;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block changedBlock, BlockPos changedPos, boolean isMoving) {
        super.m_6861_(state, world, pos, changedBlock, changedPos, isMoving);
        if (world.f_46443_) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        BlockEntity blockEntity = serverWorld.m_7702_(pos);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity machine = (CompactMachineBlockEntity)blockEntity;
            ServerLevel compactWorld = serverWorld.m_7654_().m_129880_(Dimension.COMPACT_DIMENSION);
            if (compactWorld == null) {
                CompactMachines.LOGGER.warn("Warning: Compact Dimension was null! Cannot fetch internal state for machine neighbor change listener.");
            }
        }
    }

    public static Block getBySize(RoomSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case RoomSize.TINY -> (Block)Machines.MACHINE_BLOCK_TINY.get();
            case RoomSize.SMALL -> (Block)Machines.MACHINE_BLOCK_SMALL.get();
            case RoomSize.NORMAL -> (Block)Machines.MACHINE_BLOCK_NORMAL.get();
            case RoomSize.LARGE -> (Block)Machines.MACHINE_BLOCK_LARGE.get();
            case RoomSize.GIANT -> (Block)Machines.MACHINE_BLOCK_GIANT.get();
            case RoomSize.MAXIMUM -> (Block)Machines.MACHINE_BLOCK_MAXIMUM.get();
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        Block given = CompactMachineBlock.getBySize(this.size);
        ItemStack stack = new ItemStack((ItemLike)given, 1);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity tile = (CompactMachineBlockEntity)blockEntity;
            tile.getConnectedRoom().ifPresent(room -> CompactMachineItem.setRoom(stack, room));
        }
        return stack;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity tile = (CompactMachineBlockEntity)blockEntity;
            if (worldIn instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)worldIn;
                if (!stack.m_41782_()) {
                    return;
                }
                CompoundTag nbt = stack.m_41783_();
                if (nbt == null) {
                    return;
                }
                CompactMachineItem.getRoom(stack).ifPresent(room -> {
                    DimensionMachineGraph g = DimensionMachineGraph.forDimension(sl);
                    g.connectMachineToRoom(pos, (ChunkPos)room);
                    tile.syncConnectedRoom();
                });
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        CompactMachineBlockEntity tile;
        Object cmBlock;
        Block block;
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        MinecraftServer server = level.m_7654_();
        ItemStack mainItem = player.m_21205_();
        if (mainItem.m_41619_() && (blockEntity = level.m_7702_(pos)) instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity machine = (CompactMachineBlockEntity)blockEntity;
            block = state.m_60734_();
            if (block instanceof CompactMachineBlock) {
                cmBlock = (CompactMachineBlock)block;
                machine.getConnectedRoom().ifPresent(arg_0 -> CompactMachineBlock.lambda$use$6((CompactMachineBlock)((Object)cmBlock), server, player, machine, pos, arg_0));
            }
        }
        if (mainItem.m_41720_() == Shrinking.PERSONAL_SHRINKING_DEVICE.get() && (cmBlock = level.m_7702_(pos)) instanceof CompactMachineBlockEntity) {
            tile = (CompactMachineBlockEntity)((Object)cmBlock);
            tile.getConnectedRoom().ifPresentOrElse(room -> {
                try {
                    PlayerUtil.teleportPlayerIntoMachine(level, player, pos);
                }
                catch (MissingDimensionException e) {
                    e.printStackTrace();
                }
            }, () -> this.createAndEnterRoom(player, server, tile));
        }
        if (mainItem.m_41720_() instanceof NameTagItem && mainItem.m_41788_() && (cmBlock = level.m_7702_(pos)) instanceof CompactMachineBlockEntity) {
            tile = (CompactMachineBlockEntity)((Object)cmBlock);
            tile.getConnectedRoom().ifPresentOrElse(room -> Rooms.getOwner(server, room).ifPresent(profile -> {
                try {
                    if (player.m_20148_().equals(profile.getId())) {
                        String newName = mainItem.m_41786_().m_130668_(120);
                        Rooms.updateName(server, room, newName);
                    } else {
                        player.m_5661_((Component)TranslationUtil.message(Messages.CANNOT_RENAME_NOT_OWNER, profile.getName()), true);
                    }
                }
                catch (NonexistentRoomException e) {
                    throw new RuntimeException(e);
                }
            }), () -> CompactMachines.LOGGER.warn("Tried to apply upgrade to a 'claimed' machine, but there was no owner data attached."));
        }
        if (mainItem.m_204117_(CMTags.ROOM_UPGRADE_ITEM)) {
            IForgeRegistry<RoomUpgrade> reg = MachineRoomUpgrades.REGISTRY.get();
            block = mainItem.m_41720_();
            if (block instanceof RoomUpgradeItem) {
                RoomUpgradeItem upItem = (RoomUpgradeItem)block;
                BlockEntity blockEntity2 = level.m_7702_(pos);
                if (blockEntity2 instanceof CompactMachineBlockEntity) {
                    CompactMachineBlockEntity tile2 = (CompactMachineBlockEntity)blockEntity2;
                    tile2.getConnectedRoom().ifPresent(room -> Rooms.getOwner(server, room).ifPresent(prof -> {
                        if (!player.m_20148_().equals(prof.getId())) {
                            player.m_5661_((Component)TranslationUtil.message(Messages.NOT_ROOM_OWNER, prof.getName()), true);
                            return;
                        }
                        RoomUpgrade upg = upItem.getUpgradeType();
                        RoomUpgradeManager manager = RoomUpgradeManager.get(server.m_129880_(Dimension.COMPACT_DIMENSION));
                        if (manager.hasUpgrade((ChunkPos)room, upg)) {
                            player.m_5661_((Component)TranslationUtil.message(Messages.ALREADY_HAS_UPGRADE), true);
                        } else {
                            boolean added = manager.addUpgrade(upg, (ChunkPos)room);
                            if (added) {
                                player.m_5661_((Component)TranslationUtil.message(Messages.UPGRADE_APPLIED).m_130940_(ChatFormatting.DARK_GREEN), true);
                            } else {
                                player.m_5661_((Component)TranslationUtil.message(Messages.UPGRADE_ADD_FAILED).m_130940_(ChatFormatting.DARK_RED), true);
                            }
                        }
                    }));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void createAndEnterRoom(Player player, MinecraftServer server, CompactMachineBlockEntity tile) {
        try {
            ChunkPos newRoomPos = Rooms.createNew(server, this.size, player.m_20148_());
            tile.setConnectedRoom(newRoomPos);
            PlayerUtil.teleportPlayerIntoRoom(server, player, newRoomPos, true);
            player.getCapability(RoomCapabilities.ROOM_HISTORY).ifPresent(hist -> {
                PreciseDimensionalPosition entry = PreciseDimensionalPosition.fromPlayer(player);
                hist.addHistory(new PlayerRoomHistoryItem(entry, tile.getLevelPosition()));
            });
        }
        catch (MissingDimensionException | NonexistentRoomException e) {
            CompactMachines.LOGGER.error("Error occurred while generating new room and machine info for first player entry.", e);
        }
    }

    public RoomSize getSize() {
        return this.size;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CompactMachineBlockEntity(pos, state);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean a) {
        MinecraftServer server = level.m_7654_();
        if (level.f_46443_ || server == null) {
            super.m_6810_(oldState, level, pos, newState, a);
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            MinecraftServer serv = sl.m_7654_();
            ServerLevel compactDim = serv.m_129880_(Dimension.COMPACT_DIMENSION);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CompactMachineBlockEntity) {
                CompactMachineBlockEntity entity = (CompactMachineBlockEntity)blockEntity;
                entity.getConnectedRoom().ifPresent(room -> {
                    DimensionMachineGraph dimGraph = DimensionMachineGraph.forDimension(sl);
                    dimGraph.disconnect(pos);
                    if (compactDim == null) {
                        return;
                    }
                    TunnelConnectionGraph tunnels = TunnelConnectionGraph.forRoom(compactDim, room);
                    tunnels.unregister(pos);
                });
            }
        }
        super.m_6810_(oldState, level, pos, newState, a);
    }

    private static /* synthetic */ void lambda$use$6(CompactMachineBlock cmBlock, MinecraftServer server, Player player, CompactMachineBlockEntity machine, BlockPos pos, ChunkPos room) {
        RoomSize size = cmBlock.getSize();
        try {
            Optional<String> roomName = Rooms.getRoomName(server, room);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)MachineRoomMenu.makeProvider(server, room, machine.getLevelPosition()), buf -> {
                buf.m_130064_(pos);
                buf.m_130059_(LevelBlockPosition.CODEC, (Object)machine.getLevelPosition());
                buf.m_178341_(room);
                roomName.ifPresentOrElse(name -> {
                    buf.writeBoolean(true);
                    buf.m_130070_(name);
                }, () -> buf.writeBoolean(false));
            });
        }
        catch (NonexistentRoomException e) {
            e.printStackTrace();
        }
    }
}

