/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines;

import dev.compactmods.machines.command.Commands;
import dev.compactmods.machines.config.CommonConfig;
import dev.compactmods.machines.config.EnableVanillaRecipesConfigCondition;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.Registries;
import dev.compactmods.machines.core.UIRegistration;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.graph.Graph;
import dev.compactmods.machines.machine.Machines;
import dev.compactmods.machines.room.data.LootFunctions;
import dev.compactmods.machines.shrinking.Shrinking;
import dev.compactmods.machines.tunnel.Tunnels;
import dev.compactmods.machines.upgrade.MachineRoomUpgrades;
import dev.compactmods.machines.wall.Walls;
import javax.annotation.Nonnull;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod(value="compactmachines")
public class CompactMachines {
    @Deprecated(forRemoval=true)
    public static final String MOD_ID = "compactmachines";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Marker CONN_MARKER = MarkerManager.getMarker((String)"cm_connections");
    public static final CreativeModeTab COMPACT_MACHINES_ITEMS = new CreativeModeTab("compactmachines"){

        @Nonnull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)Machines.MACHINE_BLOCK_ITEM_NORMAL.get());
        }
    };

    public CompactMachines() {
        Registries.setup();
        CompactMachines.preparePackages();
        CompactMachines.doRegistration();
        ModLoadingContext mlCtx = ModLoadingContext.get();
        mlCtx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.CONFIG);
        mlCtx.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.CONFIG);
        CraftingHelper.register((IConditionSerializer)EnableVanillaRecipesConfigCondition.Serializer.INSTANCE);
    }

    private static void doRegistration() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Registries.BLOCKS.register(bus);
        Registries.ITEMS.register(bus);
        Registries.BLOCK_ENTITIES.register(bus);
        Registries.TUNNEL_DEFINITIONS.register(bus);
        Registries.CONTAINERS.register(bus);
        Registries.UPGRADES.register(bus);
        Registries.NODE_TYPES.register(bus);
        Registries.EDGE_TYPES.register(bus);
        Registries.COMMAND_ARGUMENT_TYPES.register(bus);
        Registries.LOOT_FUNCS.register(bus);
    }

    private static void preparePackages() {
        Machines.prepare();
        Walls.prepare();
        Tunnels.prepare();
        Shrinking.prepare();
        UIRegistration.prepare();
        Dimension.prepare();
        MachineRoomUpgrades.prepare();
        Graph.prepare();
        Commands.prepare();
        LootFunctions.prepare();
    }
}

