/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.reaper.common.registry;

import earth.terrarium.botarium.api.registry.RegistryHelpers;
import earth.terrarium.botarium.api.registry.RegistryHolder;
import earth.terrarium.reaper.common.block.ReaperGeneratorBlock;
import earth.terrarium.reaper.common.block.ReaperGeneratorMenu;
import earth.terrarium.reaper.common.block.SelfIdentifyingRuneBlock;
import earth.terrarium.reaper.common.block.SoulBeaconBlock;
import earth.terrarium.reaper.common.blockentity.ReaperGeneratorBlockEntity;
import earth.terrarium.reaper.common.blockentity.SelfIdentifyingRuneBlockEntity;
import earth.terrarium.reaper.common.blockentity.SoulBeaconBlockEntity;
import earth.terrarium.reaper.common.util.Utils;
import java.util.function.Supplier;
import me.codexadrian.spirit.Spirit;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ReaperRegistry {
    public static RegistryHolder<Item> ITEMS = new RegistryHolder((Registry)Registry.f_122827_, "reaper");
    public static RegistryHolder<Block> BLOCKS = new RegistryHolder((Registry)Registry.f_122824_, "reaper");
    public static RegistryHolder<BlockEntityType<?>> BLOCK_ENTITIES = new RegistryHolder(Registry.f_122830_, "reaper");
    public static final RegistryHolder<SoundEvent> SOUNDS = new RegistryHolder(Registry.f_122821_, "reaper");
    public static final RegistryHolder<MenuType<?>> MENUS = new RegistryHolder(Registry.f_122863_, "reaper");
    public static final Supplier<Block> REAPER_GEN_BLOCK = ReaperRegistry.registerBlockWithItem("reaper_generator", () -> new ReaperGeneratorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60955_()));
    public static final Supplier<Block> SOUL_BEACON = ReaperRegistry.registerBlockWithItem("soul_beacon", () -> new SoulBeaconBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60955_()));
    public static final Supplier<BlockEntityType<?>> REAPER_GEN_BLOCK_ENTITY = BLOCK_ENTITIES.register("reaper_generator", () -> RegistryHelpers.createBlockEntityType(ReaperGeneratorBlockEntity::new, (Block[])new Block[]{REAPER_GEN_BLOCK.get()}));
    public static final Supplier<BlockEntityType<?>> SOUL_BEACON_BLOCK_ENTITY = BLOCK_ENTITIES.register("soul_beacon", () -> RegistryHelpers.createBlockEntityType(SoulBeaconBlockEntity::new, (Block[])new Block[]{SOUL_BEACON.get()}));
    public static final Supplier<SoundEvent> REAPER_GEN_SOUND = SOUNDS.register("block.reaper.slam", () -> new SoundEvent(new ResourceLocation("reaper", "block.reaper.slam")));
    public static final Supplier<MenuType<ReaperGeneratorMenu>> REAPER_GEN_MENU = MENUS.register("reaper_generator_menu", () -> RegistryHelpers.createMenuType(ReaperGeneratorMenu::new));
    public static final DamageSource REAPER_DAMAGE = new DamageSource("reaper").m_19380_().m_238403_().m_19389_().m_181120_();
    public static final Supplier<Item> RUNE_MORE_ENERGY = ITEMS.register("rune_reficiat", () -> new Item(new Item.Properties().m_41491_(Spirit.SPIRIT).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> RUNE_INSTADEATH = ITEMS.register("rune_obitus", () -> new Item(new Item.Properties().m_41491_(Spirit.SPIRIT).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> RUNE_PLAYER = ITEMS.register("rune_humano", () -> new Item(new Item.Properties().m_41491_(Spirit.SPIRIT).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> RUNE_RANGE = ITEMS.register("rune_dilato", () -> new Item(new Item.Properties().m_41491_(Spirit.SPIRIT).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> RUNE_SPEED = ITEMS.register("rune_velocitas", () -> new Item(new Item.Properties().m_41491_(Spirit.SPIRIT).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> RUNE_SPIRIT = ITEMS.register("rune_spiritus", () -> new Item(new Item.Properties().m_41491_(Spirit.SPIRIT).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> SOUL_CATALYST = ITEMS.register("soul_catalyst", () -> new Item(new Item.Properties().m_41491_(Spirit.SPIRIT).m_41497_(Rarity.RARE)));
    public static final Supplier<Block> RUNE_BLOCK_PERSONAL_FILTER = ReaperRegistry.registerBlockWithItem("rune_block_possessio", () -> new SelfIdentifyingRuneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_)));
    public static final Supplier<BlockEntityType<SelfIdentifyingRuneBlockEntity>> RUNE_BLOCK_PERSONAL_FILTER_ENTITY = BLOCK_ENTITIES.register("rune_block_possessio", () -> RegistryHelpers.createBlockEntityType(SelfIdentifyingRuneBlockEntity::new, (Block[])new Block[]{RUNE_BLOCK_PERSONAL_FILTER.get()}));
    public static final Supplier<Block> RUNE_BLOCK_HOSTILE_FILTER = ReaperRegistry.registerBlockWithItem("rune_block_hostilis", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_)));
    public static final Supplier<Block> RUNE_BLOCK_NEUTRAL_FILTER = ReaperRegistry.registerBlockWithItem("rune_block_beastia", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_)));
    public static final Supplier<Block> RUNE_BLOCK_RANGE = ReaperRegistry.registerBlockWithItem("rune_block_dilato", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_)));
    public static final Supplier<Block> RUNE_BLOCK_DOUBLE = ReaperRegistry.registerBlockWithItem("rune_block_duplici", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_)));
    public static final Supplier<Block> RUNE_BLOCK_EFFICIENCY = ReaperRegistry.registerBlockWithItem("rune_block_efficacia", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_)));
    public static final TagKey<Item> RUNES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("reaper", "rune"));

    public static Supplier<Block> registerBlockWithItem(String name, Supplier<Block> block) {
        Supplier blockRegistry = BLOCKS.register(name, block);
        ITEMS.register(name, () -> ReaperRegistry.lambda$registerBlockWithItem$20((Supplier)blockRegistry));
        return blockRegistry;
    }

    public static void init() {
    }

    public static void register() {
        ITEMS.initialize();
        BLOCKS.initialize();
        BLOCK_ENTITIES.initialize();
        SOUNDS.initialize();
        MENUS.initialize();
    }

    public static DamageSource playerSource(ServerLevel serverLevel) {
        return new EntityDamageSource("reaper", (Entity)Utils.makeFakePlayer(serverLevel)).m_19380_().m_238403_().m_19389_().m_181120_();
    }

    private static /* synthetic */ BlockItem lambda$registerBlockWithItem$20(Supplier blockRegistry) {
        return new BlockItem((Block)blockRegistry.get(), new Item.Properties().m_41491_(Spirit.SPIRIT).m_41497_(Rarity.RARE));
    }
}

