/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.reaper.common.blockentity;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.energy.ExtractOnlyEnergyContainer;
import earth.terrarium.botarium.api.item.ItemContainerBlock;
import earth.terrarium.botarium.api.item.SimpleItemContainer;
import earth.terrarium.botarium.api.menu.ExtraDataMenuProvider;
import earth.terrarium.reaper.common.block.ReaperGeneratorData;
import earth.terrarium.reaper.common.block.ReaperGeneratorMenu;
import earth.terrarium.reaper.common.registry.ReaperRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import me.codexadrian.spirit.Corrupted;
import me.codexadrian.spirit.entity.EntityRarity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

@ParametersAreNonnullByDefault
public class ReaperGeneratorBlockEntity
extends BlockEntity
implements EnergyBlock,
ItemContainerBlock,
IAnimatable,
ExtraDataMenuProvider {
    private ExtractOnlyEnergyContainer energyContainer;
    private SimpleItemContainer itemContainer;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final Predicate<Entity> ISNT_CORRUPTED = entity -> {
        Corrupted corrupted;
        return entity instanceof Corrupted && !(corrupted = (Corrupted)entity).isCorrupted();
    };
    public double distance;
    public int cooldown = 100;
    private int animationTick = 0;

    public ReaperGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ReaperRegistry.REAPER_GEN_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public ExtractOnlyEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new ExtractOnlyEnergyContainer((Updatable)this, 1000000L)) : this.energyContainer;
    }

    public void tick() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getEnergyStorage().extractEnergy(1L, true) == 1L) {
                EnergyHooks.distributeEnergyNearby((BlockEntity)this);
            }
            if (this.distance < (double)this.getMaxRange() && this.cooldown == 0) {
                if (this.distance == 0.0) {
                    ContainerHelper.m_18956_((Container)this.getContainer(), itemStack -> itemStack.m_150930_(ReaperRegistry.SOUL_CATALYST.get()), (int)1, (boolean)false);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.3, (double)this.f_58858_.m_123343_() + 0.5, 15, 0.4, 0.75, 0.4, 0.1);
                }
                this.distance += 0.49;
                double percent = this.distance / (double)this.getMaxRange();
                for (double i = 0.0; i < Math.PI * 2; i += 0.3 * (1.0 - percent * 0.5)) {
                    double size = (double)this.getMaxRange() * percent;
                    double x = (double)this.m_58899_().m_123341_() + 0.5;
                    double z = (double)this.m_58899_().m_123343_() + 0.5;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x + size * Math.cos(i), (double)this.m_58899_().m_123342_() + 0.5, z + size * Math.sin(i), 1, 0.1, 0.1, 0.1, 0.1);
                }
                List entities = this.f_58857_.m_6443_(LivingEntity.class, new AABB(this.m_58899_()).m_82400_((double)this.getMaxRange()), EntitySelector.f_20408_.and(ISNT_CORRUPTED).and(entity -> !(entity instanceof Player) || this.getContainer().m_216874_(stack -> stack.m_150930_(ReaperRegistry.RUNE_PLAYER.get()))).and(entity -> this.isInRange((Entity)entity, this.distance)));
                for (LivingEntity entity2 : entities) {
                    double healthLost;
                    boolean hurt;
                    double healthBefore = entity2.m_21223_();
                    double entityX = entity2.m_20185_();
                    double entityY = entity2.m_20186_();
                    double entityZ = entity2.m_20189_();
                    EntityType entityType = entity2.m_6095_();
                    DamageSource reaperDamage = ReaperRegistry.REAPER_DAMAGE;
                    boolean spiritus = false;
                    if (this.getContainer().m_216874_(stack -> stack.m_150930_(ReaperRegistry.RUNE_SPIRIT.get()))) {
                        reaperDamage = ReaperRegistry.playerSource(serverLevel);
                        spiritus = true;
                    }
                    if (!(hurt = entity2.m_6469_(reaperDamage, this.getDamage() > 0 ? (float)this.getDamage() : Float.MAX_VALUE))) continue;
                    if (this.getDamage() == -1) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123786_, entityX, entityY, entityZ, 5, 0.1, 0.1, 0.1, 0.1);
                        healthLost = healthBefore;
                    } else {
                        healthLost = healthBefore - (double)entity2.m_21223_();
                    }
                    if (!spiritus) {
                        this.getEnergyStorage().internalInsert((long)((int)(healthLost * (double)this.getEnergyGeneration() * EntityRarity.getRarity((EntityType)entityType).energyModifer)), false);
                    }
                    for (double mobDis = 0.0; mobDis < 1.0; mobDis += 0.2) {
                        if (this.getDamage() > 0) {
                            entity2.m_20256_(entity2.m_20184_().m_82520_(0.0, 0.065, 0.0));
                        }
                        double x = (double)this.m_58899_().m_123341_() + 0.5 - entityX;
                        double y = (double)this.m_58899_().m_123342_() + 0.5 - entityY;
                        double z = (double)this.m_58899_().m_123343_() + 0.5 - entityZ;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)this.m_58899_().m_123341_() + 0.5 - x * mobDis, (double)this.m_58899_().m_123342_() + 0.75 - y * mobDis, (double)this.m_58899_().m_123343_() + 0.5 - z * mobDis, 5, 0.01, 0.01, 0.01, 0.005);
                    }
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, entityX, entityY + 0.5, entityZ, 10, 0.5, 0.5, 0.5, 0.05);
                }
            } else {
                if (this.cooldown == 0) {
                    this.distance = 0.0;
                    this.cooldown = this.getMaxCooldown();
                    this.update();
                }
                if (this.cooldown > 0 && this.getContainer().m_216874_(stack -> stack.m_150930_(ReaperRegistry.SOUL_CATALYST.get())) && this.getEnergyStorage().internalInsert(1L, true) == 1L) {
                    --this.cooldown;
                    this.update();
                    if (this.cooldown == 36) {
                        this.f_58857_.m_5594_(null, this.f_58858_, ReaperRegistry.REAPER_GEN_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        } else {
            if (this.f_58857_ == null) {
                return;
            }
            this.animationTick = this.cooldown < 36 ? ++this.animationTick : (this.animationTick > 36 && this.animationTick < 60 ? ++this.animationTick : 0);
        }
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.cooldown = compoundTag.m_128451_("Cooldown");
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_("Cooldown", this.cooldown);
    }

    public boolean isInRange(Entity entity, double distance) {
        double diffZ;
        double diffX = Math.abs(entity.m_20185_()) - Math.abs((double)this.m_58899_().m_123341_() + 0.5);
        double sqrt = Math.sqrt(diffX * diffX + (diffZ = Math.abs(entity.m_20189_()) - Math.abs((double)this.m_58899_().m_123343_() + 0.5)) * diffZ);
        return sqrt < distance && sqrt > distance - 1987.0;
    }

    public int getMaxRange() {
        return this.getContainer().m_216874_(stack -> stack.m_150930_(ReaperRegistry.RUNE_RANGE.get())) ? 8 : 5;
    }

    public int getDamage() {
        return this.getContainer().m_216874_(stack -> stack.m_150930_(ReaperRegistry.RUNE_INSTADEATH.get())) ? -1 : 5;
    }

    public int getEnergyGeneration() {
        return this.getContainer().m_216874_(stack -> stack.m_150930_(ReaperRegistry.RUNE_MORE_ENERGY.get())) ? 100 : 50;
    }

    public void update() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::idle));
    }

    public PlayState idle(AnimationEvent<ReaperGeneratorBlockEntity> event) {
        if (this.animationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("slam", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public SimpleItemContainer getContainer() {
        return this.itemContainer == null ? (this.itemContainer = new SimpleItemContainer((BlockEntity)this, 8)) : this.itemContainer;
    }

    public void writeExtraData(ServerPlayer player, FriendlyByteBuf buf) {
        buf.m_130064_(this.m_58899_());
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Reaper Generator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new ReaperGeneratorMenu((Container)this.getContainer(), new ReaperGeneratorData(this), i, inventory, this);
    }

    public int getMaxCooldown() {
        return this.getContainer().m_216874_(stack -> stack.m_150930_(ReaperRegistry.RUNE_SPEED.get())) ? 60 : 120;
    }
}

