/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElementValueType;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiBox;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeStringRenderPattern;

public class GuiElementValueTypeString<G extends GuiComponent, C extends AbstractContainerMenu>
implements IGuiInputElementValueType<GuiElementValueTypeStringRenderPattern, G, C> {
    private final IValueType valueType;
    private Predicate<IValue> validator;
    private final IConfigRenderPattern renderPattern;
    private String defaultInputString;
    private String inputString;

    public GuiElementValueTypeString(IValueType valueType, IConfigRenderPattern renderPattern) {
        this.valueType = valueType;
        this.validator = Predicates.alwaysTrue();
        this.renderPattern = renderPattern;
        this.defaultInputString = ValueHelpers.toString(this.getValueType().getDefault());
    }

    @Override
    public void setValue(IValue value, GuiElementValueTypeStringRenderPattern propertyConfigPattern) {
        this.setInputString(ValueHelpers.toString(value), propertyConfigPattern);
    }

    public void setInputString(String inputString, GuiElementValueTypeStringRenderPattern subGui) {
        this.inputString = inputString;
        if (subGui != null) {
            subGui.getTextField().m_94144_(inputString);
        }
    }

    @Override
    public void setValidator(Predicate<IValue> validator) {
        this.validator = validator;
    }

    @Override
    public IValue getValue() {
        try {
            return ValueHelpers.parseString(this.getValueType(), this.getInputString());
        }
        catch (EvaluationException e) {
            return this.getValueType().getDefault();
        }
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)this.getValueType().getTranslationKey());
    }

    @Override
    public void loadTooltip(List<Component> lines) {
        this.getValueType().loadTooltip(lines, true, null);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return this.renderPattern;
    }

    @Override
    public void activate() {
        this.inputString = this.defaultInputString;
    }

    @Override
    public void deactivate() {
        this.inputString = null;
    }

    @Override
    public Component validate() {
        try {
            Object value = this.getValueType().parseString(this.inputString);
            if (!this.validator.test((IValue)value)) {
                return Component.m_237115_((String)"valuetype.integrateddynamics.error.value");
            }
        }
        catch (EvaluationException e) {
            return e.getErrorMessage();
        }
        return null;
    }

    @Override
    public int getColor() {
        return this.getValueType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return L10NHelpers.localize((String)this.getValueType().getTranslationKey(), (Object[])new Object[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiElementValueTypeStringRenderPattern<?, G, C> createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        return new GuiElementValueTypeStringRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    public IValueType getValueType() {
        return this.valueType;
    }

    public Predicate<IValue> getValidator() {
        return this.validator;
    }

    public String getDefaultInputString() {
        return this.defaultInputString;
    }

    public String getInputString() {
        return this.inputString;
    }

    public void setDefaultInputString(String defaultInputString) {
        this.defaultInputString = defaultInputString;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiElementValueTypeString)) {
            return false;
        }
        GuiElementValueTypeString other = (GuiElementValueTypeString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IValueType this$valueType = this.getValueType();
        IValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        Predicate<IValue> this$validator = this.getValidator();
        Predicate<IValue> other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
            return false;
        }
        IConfigRenderPattern this$renderPattern = this.getRenderPattern();
        IConfigRenderPattern other$renderPattern = other.getRenderPattern();
        if (this$renderPattern == null ? other$renderPattern != null : !this$renderPattern.equals(other$renderPattern)) {
            return false;
        }
        String this$defaultInputString = this.getDefaultInputString();
        String other$defaultInputString = other.getDefaultInputString();
        if (this$defaultInputString == null ? other$defaultInputString != null : !this$defaultInputString.equals(other$defaultInputString)) {
            return false;
        }
        String this$inputString = this.getInputString();
        String other$inputString = other.getInputString();
        return !(this$inputString == null ? other$inputString != null : !this$inputString.equals(other$inputString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiElementValueTypeString;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        Predicate<IValue> $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 43 : $validator.hashCode());
        IConfigRenderPattern $renderPattern = this.getRenderPattern();
        result = result * 59 + ($renderPattern == null ? 43 : $renderPattern.hashCode());
        String $defaultInputString = this.getDefaultInputString();
        result = result * 59 + ($defaultInputString == null ? 43 : $defaultInputString.hashCode());
        String $inputString = this.getInputString();
        result = result * 59 + ($inputString == null ? 43 : $inputString.hashCode());
        return result;
    }

    public String toString() {
        return "GuiElementValueTypeString(valueType=" + this.getValueType() + ", validator=" + this.getValidator() + ", renderPattern=" + this.getRenderPattern() + ", defaultInputString=" + this.getDefaultInputString() + ", inputString=" + this.getInputString() + ")";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class SubGuiValueTypeInfo<S extends ISubGuiBox, G extends ContainerScreenExtended<?>, C extends AbstractContainerMenu>
    extends SubGuiBox.Base {
        private final IGuiInputElement element;
        protected final G gui;
        protected final C container;

        public SubGuiValueTypeInfo(G gui, C container, IGuiInputElement<S, G, C> element, int x, int y, int width, int height) {
            super(SubGuiBox.Box.DARK, x, y, width, height);
            this.gui = gui;
            this.container = container;
            this.element = element;
        }

        protected abstract boolean showError();

        protected abstract Component getLastError();

        protected abstract ResourceLocation getTexture();

        protected int getSignalX() {
            return this.getWidth() - 22;
        }

        protected int getSignalY() {
            return (this.getHeight() - 12) / 2;
        }

        @Override
        public void renderBg(PoseStack matrixStack, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.renderBg(matrixStack, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            fontRenderer.m_92763_(matrixStack, this.element.getName(), (float)(x + 2), (float)(y + 6), Helpers.RGBToInt((int)240, (int)240, (int)240));
            if (this.showError()) {
                Component lastError = this.getLastError();
                if (lastError != null) {
                    Images.ERROR.draw((GuiComponent)this, matrixStack, x + this.getSignalX(), y + this.getSignalY() - 1);
                } else {
                    Images.OK.draw((GuiComponent)this, matrixStack, x + this.getSignalX(), y + this.getSignalY() + 1);
                }
            }
        }

        @Override
        public void drawGuiContainerForegroundLayer(PoseStack matrixStack, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
            Component lastError;
            super.drawGuiContainerForegroundLayer(matrixStack, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            int x = this.getX();
            int y = this.getY();
            if (this.showError() && (lastError = this.getLastError()) != null && this.gui.m_6774_(x + this.getSignalX(), y + this.getSignalY() - 1, Images.ERROR.getSheetWidth(), Images.ERROR.getSheetHeight(), (double)mouseX, (double)mouseY)) {
                List lines = StringHelpers.splitLines((String)lastError.getString(), (int)25, (String)ChatFormatting.RED.toString()).stream().map(Component::m_237113_).collect(Collectors.toList());
                this.gui.drawTooltip(lines, matrixStack, mouseX - guiLeft, mouseY - guiTop);
            }
        }
    }
}

