/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNumber;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeLong
extends ValueTypeBase<ValueLong>
implements IValueTypeNumber<ValueLong> {
    public ValueTypeLong() {
        super("long", Helpers.RGBToInt((int)215, (int)254, (int)23), ChatFormatting.YELLOW, ValueLong.class);
    }

    @Override
    public ValueLong getDefault() {
        return ValueLong.of(0L);
    }

    @Override
    public MutableComponent toCompactString(ValueLong value) {
        return Component.m_237113_((String)Long.toString(value.getRawValue()));
    }

    @Override
    public Tag serialize(ValueLong value) {
        return LongTag.m_128882_((long)value.getRawValue());
    }

    @Override
    public ValueLong deserialize(Tag value) {
        if (value.m_7060_() == 4) {
            return ValueLong.of(((LongTag)value).m_7046_());
        }
        throw new IllegalArgumentException(String.format("Value \"%s\" could not be parsed to a long.", value));
    }

    @Override
    public String toString(ValueLong value) {
        return Long.toString(value.getRawValue());
    }

    @Override
    public ValueLong parseString(String value) throws EvaluationException {
        try {
            return ValueLong.of(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.parse", (Object[])new Object[]{value, Component.m_237115_((String)this.getTranslationKey())}));
        }
    }

    @Override
    public boolean isZero(ValueLong a) {
        return a.getRawValue() == 0L;
    }

    @Override
    public boolean isOne(ValueLong a) {
        return a.getRawValue() == 1L;
    }

    @Override
    public ValueLong add(ValueLong a, ValueLong b) {
        return ValueLong.of(a.getRawValue() + b.getRawValue());
    }

    @Override
    public ValueLong subtract(ValueLong a, ValueLong b) {
        return ValueLong.of(a.getRawValue() - b.getRawValue());
    }

    @Override
    public ValueLong multiply(ValueLong a, ValueLong b) {
        return ValueLong.of(a.getRawValue() * b.getRawValue());
    }

    @Override
    public ValueLong divide(ValueLong a, ValueLong b) {
        return ValueLong.of(a.getRawValue() / b.getRawValue());
    }

    @Override
    public ValueLong max(ValueLong a, ValueLong b) {
        return ValueLong.of(Math.max(a.getRawValue(), b.getRawValue()));
    }

    @Override
    public ValueLong min(ValueLong a, ValueLong b) {
        return ValueLong.of(Math.min(a.getRawValue(), b.getRawValue()));
    }

    @Override
    public boolean greaterThan(ValueLong a, ValueLong b) {
        return a.getRawValue() > b.getRawValue();
    }

    @Override
    public boolean lessThan(ValueLong a, ValueLong b) {
        return a.getRawValue() < b.getRawValue();
    }

    @Override
    public ValueTypeInteger.ValueInteger round(ValueLong a) {
        return ValueTypeInteger.ValueInteger.of((int)a.getRawValue());
    }

    @Override
    public ValueTypeInteger.ValueInteger ceil(ValueLong a) {
        return ValueTypeInteger.ValueInteger.of((int)a.getRawValue());
    }

    @Override
    public ValueTypeInteger.ValueInteger floor(ValueLong a) {
        return ValueTypeInteger.ValueInteger.of((int)a.getRawValue());
    }

    @Override
    public ValueTypeString.ValueString compact(ValueLong a) {
        NumberFormat nf = NumberFormat.getCompactNumberInstance(Locale.US, GeneralConfig.numberCompactUseLongStyle ? NumberFormat.Style.LONG : NumberFormat.Style.SHORT);
        nf.setMinimumFractionDigits(GeneralConfig.numberCompactMinimumFractionDigits);
        nf.setMaximumFractionDigits(GeneralConfig.numberCompactMaximumFractionDigits);
        nf.setMinimumIntegerDigits(GeneralConfig.numberCompactMinimumIntegerDigits);
        nf.setMaximumIntegerDigits(GeneralConfig.numberCompactMaximumIntegerDigits);
        return ValueTypeString.ValueString.of(nf.format(a.getRawValue()));
    }

    @Override
    public String getName(ValueLong a) {
        return this.toCompactString(a).getString();
    }

    public static class ValueLong
    extends ValueBase {
        private final long value;

        private ValueLong(long value) {
            super(ValueTypes.LONG);
            this.value = value;
        }

        public static ValueLong of(long value) {
            return new ValueLong(value);
        }

        public long getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueLong && ((ValueLong)o).value == this.value;
        }

        public int hashCode() {
            return this.getType().hashCode() + (int)this.value;
        }

        @Override
        public String toString() {
            return "ValueTypeLong.ValueLong(value=" + this.value + ")";
        }
    }
}

