/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.energeticsheep.entity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.EntityConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.energeticsheep.EnergeticSheep;
import org.cyclops.energeticsheep.client.render.entity.RenderEntityEnergeticSheep;
import org.cyclops.energeticsheep.entity.EntityEnergeticSheep;
import org.cyclops.energeticsheep.entity.layers.LayerEnergeticSheepCharge;

public class EntityEnergeticSheepConfig
extends EntityConfig<EntityEnergeticSheep> {
    @ConfigurableProperty(category="mob", comment="How much base energy the sheep can regenerate each time.", configLocation=ModConfig.Type.SERVER)
    public static int sheepBaseCapacity = 20000;
    @ConfigurableProperty(category="mob", comment="How much base energy energetic wool wool has.", configLocation=ModConfig.Type.SERVER)
    public static int woolBaseCapacity = 500;
    @ConfigurableProperty(category="mob", comment="This factor will be multiplied by the ordinal value of the color, and will be multiplied with the base sheepBaseCapacity of the sheep.", isCommandable=true)
    public static double additionalCapacityColorFactor = 0.075;
    @ConfigurableProperty(category="mob", comment="The 1/X chance on having an energetic baby when breeding.", configLocation=ModConfig.Type.SERVER, isCommandable=true)
    public static int babyChance = 3;
    @ConfigurableProperty(category="mob", comment="The 1/X chance on having an energetic baby when breeding with a power-breeding item.", configLocation=ModConfig.Type.SERVER, isCommandable=true)
    public static int babyChancePowerBreeding = 1;
    @ConfigurableProperty(category="mob", comment="The items that can be used to power-breed sheep, by unique item name.", configLocation=ModConfig.Type.SERVER)
    public static List<String> powerBreedingItems = Lists.newArrayList((Object[])new String[]{"minecraft:rabbit_stew", "minecraft:chorus_fruit", "integrateddynamics:menril_berries"});

    public EntityEnergeticSheepConfig() {
        super((ModBase)EnergeticSheep._instance, "energetic_sheep", eConfig -> EntityType.Builder.m_20704_(EntityEnergeticSheep::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20719_());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEntityAttributesModification);
        DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(LayerEnergeticSheepCharge::loadLayerDefinitions);
            return null;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRegistered() {
        super.onRegistered();
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityRenderer<? super EntityEnergeticSheep> getRender(EntityRendererProvider.Context renderContext, ItemRenderer itemRenderer) {
        return new RenderEntityEnergeticSheep(renderContext, (ExtendedConfig<?, ?>)this);
    }

    public void onEntityAttributesModification(EntityAttributeModificationEvent event) {
        event.add((EntityType)this.getInstance(), Attributes.f_22276_);
        event.add((EntityType)this.getInstance(), Attributes.f_22278_);
        event.add((EntityType)this.getInstance(), Attributes.f_22279_);
        event.add((EntityType)this.getInstance(), Attributes.f_22284_);
        event.add((EntityType)this.getInstance(), Attributes.f_22285_);
        event.add((EntityType)this.getInstance(), (Attribute)ForgeMod.SWIM_SPEED.get());
        event.add((EntityType)this.getInstance(), (Attribute)ForgeMod.NAMETAG_DISTANCE.get());
        event.add((EntityType)this.getInstance(), (Attribute)ForgeMod.ENTITY_GRAVITY.get());
        event.add((EntityType)this.getInstance(), Attributes.f_22277_, 16.0);
        event.add((EntityType)this.getInstance(), Attributes.f_22282_);
        event.add((EntityType)this.getInstance(), Attributes.f_22276_, 8.0);
        event.add((EntityType)this.getInstance(), Attributes.f_22279_, (double)0.23f);
    }
}

