/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.blockrunner.BlockRunner;
import fuzs.blockrunner.data.SpeedHolderValue;
import fuzs.blockrunner.init.ModRegistry;
import fuzs.blockrunner.network.message.S2CBlockSpeedMessage;
import fuzs.puzzleslib.core.CoreServices;
import fuzs.puzzleslib.json.JsonConfigFileUtil;
import fuzs.puzzleslib.network.Message;
import fuzs.puzzleslib.proxy.Proxy;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class BlockSpeedManager
implements PreparableReloadListener {
    public static final BlockSpeedManager INSTANCE = new BlockSpeedManager();
    public static final UUID SPEED_MODIFIER_BLOCK_SPEED_UUID = UUID.fromString("23237052-61AD-11EB-AE93-0242AC130002");
    private static final String CONFIG_FILE_NAME = "blockrunner.json";
    private static final Set<SpeedHolderValue> DEFAULT_BLOCK_SPEEDS = new SpeedHolderValue.Builder().add(ModRegistry.VERY_SLOW_BLOCKS_BLOCK_TAG, 0.45).add(ModRegistry.SLOW_BLOCKS_BLOCK_TAG, 0.65).add(ModRegistry.SLIGHTLY_SLOW_BLOCKS_BLOCK_TAG, 0.85).add(ModRegistry.SLIGHTLY_QUICK_BLOCKS_BLOCK_TAG, 1.15).add(ModRegistry.QUICK_BLOCKS_BLOCK_TAG, 1.35).add(ModRegistry.VERY_QUICK_BLOCKS_BLOCK_TAG, 1.55).build();
    private final Set<SpeedHolderValue> blockSpeedValues = Sets.newHashSet();
    private Map<Block, Double> blockSpeeds;

    public void onPlayerLoggedIn(Player player) {
        if (CoreServices.ENVIRONMENT.isServer()) {
            BlockRunner.NETWORK.sendTo((Message)new S2CBlockSpeedMessage(this.serialize(this.blockSpeedValues)), (ServerPlayer)player);
        }
    }

    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier p_10780_, ResourceManager p_10781_, ProfilerFiller p_10782_, ProfilerFiller p_10783_, Executor p_10784_, Executor p_10785_) {
        return p_10780_.m_6769_((Object)Unit.INSTANCE).thenRunAsync(this::load, p_10785_);
    }

    public void load() {
        JsonConfigFileUtil.getAndLoad((String)CONFIG_FILE_NAME, this::serialize, this::deserialize);
        if (CoreServices.ENVIRONMENT.isServer() && Proxy.INSTANCE.getGameServer() != null) {
            BlockRunner.NETWORK.sendToAll((Message)new S2CBlockSpeedMessage(this.serialize(this.blockSpeedValues)));
        }
    }

    private void dissolve() {
        if (this.blockSpeeds == null) {
            HashMap blockSpeeds = Maps.newHashMap();
            try {
                for (SpeedHolderValue value : this.blockSpeedValues) {
                    value.addValues(blockSpeeds);
                }
            }
            catch (Exception e) {
                BlockRunner.LOGGER.error(e.getMessage());
                blockSpeeds.clear();
            }
            this.blockSpeeds = blockSpeeds;
        }
    }

    public boolean hasBlockSpeed(Block block) {
        this.dissolve();
        return this.blockSpeeds.containsKey(block);
    }

    public double getSpeedFactor(Block block) {
        this.dissolve();
        return this.blockSpeeds.getOrDefault(block, 1.0);
    }

    private void serialize(File jsonFile) {
        JsonConfigFileUtil.saveToFile((File)jsonFile, (JsonElement)this.serialize(DEFAULT_BLOCK_SPEEDS));
    }

    private JsonObject serialize(Set<SpeedHolderValue> values) {
        JsonObject jsonElements = new JsonObject();
        for (SpeedHolderValue value : values) {
            value.serialize(jsonElements);
        }
        return jsonElements;
    }

    private void deserialize(FileReader reader) {
        this.deserialize((JsonObject)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonObject.class));
    }

    public void deserialize(JsonObject jsonElements) {
        this.blockSpeedValues.clear();
        this.blockSpeeds = null;
        HashSet blockSpeedValues = Sets.newHashSet();
        for (Map.Entry entry : jsonElements.entrySet()) {
            String key = (String)entry.getKey();
            double speedValue = ((JsonElement)entry.getValue()).getAsDouble();
            if (key.startsWith("#")) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(key.substring(1)));
                blockSpeedValues.add(new SpeedHolderValue.TagValue((TagKey<Block>)tag, speedValue));
                continue;
            }
            ResourceLocation resourcelocation = new ResourceLocation(key);
            if (Registry.f_122824_.m_7804_(resourcelocation)) {
                Block block = (Block)Registry.f_122824_.m_7745_(resourcelocation);
                blockSpeedValues.add(new SpeedHolderValue.BlockValue(block, speedValue));
                continue;
            }
            BlockRunner.LOGGER.warn("Unknown block type '{}', valid types are: {}", (Object)resourcelocation, (Object)Joiner.on((String)", ").join((Iterable)Registry.f_122824_.m_6566_()));
        }
        this.blockSpeedValues.addAll(blockSpeedValues);
    }
}

