/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles;

import java.awt.Color;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.zeith.botanicadds.api.tile.IElvenGatewayPylonTile;
import org.zeith.botanicadds.init.ItemsBA;
import org.zeith.botanicadds.init.TilesBA;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.tiles.TileSyncable;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.xplat.BotaniaConfig;

public class TileGaiasteelPylon
extends TileSyncable
implements IElvenGatewayPylonTile {
    @NBTSerializable
    boolean activated = false;
    @NBTSerializable
    BlockPos centerPos;
    private int ticks = 0;

    public TileGaiasteelPylon(BlockPos pos, BlockState state) {
        super(TilesBA.GAIASTEEL_PYLON, pos, state);
    }

    public static float dither(float base, float by) {
        return Mth.m_14036_((float)(base + ((float)Math.random() - (float)Math.random()) * by), (float)0.0f, (float)1.0f);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TileGaiasteelPylon self) {
        ++self.ticks;
        Color rgb = ItemsBA.GAIASTEEL_COLOR;
        if (self.activated && level.f_46443_) {
            if (self.portalOff() || !(level.m_7702_(pos.m_7495_()) instanceof ManaPoolBlockEntity)) {
                self.activated = false;
                return;
            }
            Vec3 centerBlock = new Vec3((double)self.centerPos.m_123341_() + 0.5, (double)self.centerPos.m_123342_() + 0.75 + (Math.random() - 0.125), (double)self.centerPos.m_123343_() + 0.5);
            if (BotaniaConfig.client().elfPortalParticlesEnabled()) {
                double worldTime = self.ticks;
                worldTime += (double)new Random(pos.hashCode()).nextInt(1000);
                float r = 0.75f + (float)Math.random() * 0.05f;
                double x = (double)pos.m_123341_() + 0.5 + Math.cos(worldTime /= 5.0) * (double)r;
                double z = (double)pos.m_123343_() + 0.5 + Math.sin(worldTime) * (double)r;
                Vec3 ourCoords = new Vec3(x, (double)pos.m_123342_() + 0.25, z);
                centerBlock = centerBlock.m_82492_(0.0, 0.5, 0.0);
                Vec3 mov = centerBlock.m_82546_(ourCoords).m_82541_().m_82490_(0.2);
                WispParticleData data = WispParticleData.wisp((float)(0.25f + (float)Math.random() * 0.1f), (float)TileGaiasteelPylon.dither((float)rgb.getRed() / 255.0f, 0.15f), (float)TileGaiasteelPylon.dither((float)rgb.getGreen() / 255.0f, 0.15f), (float)TileGaiasteelPylon.dither((float)rgb.getBlue() / 255.0f, 0.15f), (float)1.0f);
                level.m_7106_((ParticleOptions)data, x, (double)pos.m_123342_() + 0.25, z, 0.0, (double)(-(-0.075f - (float)Math.random() * 0.015f)), 0.0);
                if (level.f_46441_.m_188503_(3) == 0) {
                    data = WispParticleData.wisp((float)(0.25f + (float)Math.random() * 0.1f), (float)TileGaiasteelPylon.dither((float)rgb.getRed() / 255.0f, 0.15f), (float)TileGaiasteelPylon.dither((float)rgb.getGreen() / 255.0f, 0.15f), (float)TileGaiasteelPylon.dither((float)rgb.getBlue() / 255.0f, 0.15f));
                    level.m_7106_((ParticleOptions)data, x, (double)pos.m_123342_() + 0.25, z, (double)((float)mov.f_82479_), (double)((float)mov.f_82480_), (double)((float)mov.f_82481_));
                }
            }
        }
        if (level.f_46441_.m_188499_() && level.f_46443_) {
            SparkleParticleData data = SparkleParticleData.sparkle((float)((float)Math.random()), (float)((float)rgb.getRed() / 255.0f), (float)((float)rgb.getGreen() / 255.0f), (float)((float)rgb.getBlue() / 255.0f), (int)2);
            level.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random() * 1.5, (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    private boolean portalOff() {
        return !this.f_58857_.m_8055_(this.centerPos).m_60713_(BotaniaBlocks.alfPortal) || this.f_58857_.m_8055_(this.centerPos).m_61143_((Property)BotaniaStateProperties.ALFPORTAL_STATE) == AlfheimPortalState.OFF;
    }

    @Override
    public float getManaCostMultiplier() {
        return 0.25f;
    }

    @Override
    public void activate(BlockPos corePos) {
        this.activated = true;
        this.centerPos = corePos;
    }

    @Override
    public void deactivate() {
        this.activated = false;
    }
}

