/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.BotanicAdditions;
import org.zeith.botanicadds.blocks.BlockGaiasteelPylon;
import org.zeith.botanicadds.client.model.ModelGaiasteelPylon;
import org.zeith.botanicadds.mixins.RenderHelperAccessor;
import org.zeith.botanicadds.tiles.TileGaiasteelPylon;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.render.block_entity.TEISR;

public class TESRGaiasteelPylon
implements BlockEntityRenderer<TileGaiasteelPylon> {
    public static final ResourceLocation GAIASTEEL_TEXTURE = BotanicAdditions.id("textures/block/gaiasteel_pylon.png");
    public static final RenderType NATURA_PYLON_GLOW = RenderHelperAccessor.callGetPylonGlow_BotanicAdditions("gaiasteel_pylon_glow", GAIASTEEL_TEXTURE);
    public static final RenderType NATURA_PYLON_GLOW_DIRECT = RenderHelperAccessor.callGetPylonGlowDirect_BotanicAdditions("gaiasteel_pylon_glow_direct", GAIASTEEL_TEXTURE);
    private final ModelGaiasteelPylon model;
    private static ItemTransforms.TransformType forceTransform = ItemTransforms.TransformType.NONE;

    public TESRGaiasteelPylon(BlockEntityRendererProvider.Context ctx) {
        this.model = new ModelGaiasteelPylon(ctx.m_173582_(BotaniaModelLayers.PYLON_NATURA));
    }

    public void render(@Nullable TileGaiasteelPylon pylon, float pticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        boolean renderingItem = pylon == null;
        boolean direct = renderingItem && (forceTransform == ItemTransforms.TransformType.GUI || forceTransform.m_111841_());
        RenderType shaderLayer = direct ? NATURA_PYLON_GLOW_DIRECT : NATURA_PYLON_GLOW;
        ms.m_85836_();
        float worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += pylon == null ? 0.0f : (float)new Random(pylon.m_58899_().hashCode()).nextInt(360);
        ms.m_85837_(0.0, pylon == null ? 1.35 : 1.5, 0.0);
        ms.m_85841_(1.0f, -1.0f, -1.0f);
        ms.m_85836_();
        ms.m_85837_(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.m_85845_(Vector3f.f_122225_.m_122240_(worldTime * 1.5f));
        }
        RenderType layer = RenderType.m_110473_((ResourceLocation)GAIASTEEL_TEXTURE);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        VertexConsumer buffer = buffers.m_6299_(layer);
        this.model.renderRing(ms, buffer, light, overlay, r, g, b, a);
        if (pylon != null) {
            ms.m_85837_(0.0, Math.sin((double)worldTime / 20.0) / 20.0 - 0.025, 0.0);
        }
        ms.m_85849_();
        ms.m_85836_();
        if (pylon != null) {
            ms.m_85837_(0.0, Math.sin((double)worldTime / 20.0) / 17.5, 0.0);
        }
        ms.m_85837_(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.m_85845_(Vector3f.f_122225_.m_122240_(-worldTime));
        }
        buffer = buffers.m_6299_(shaderLayer);
        this.model.renderCrystal(ms, buffer, light, overlay, r, g, b, a);
        ms.m_85849_();
        ms.m_85849_();
    }

    public static class ItemRenderer
    extends TEISR {
        public ItemRenderer(Block block) {
            super(block);
        }

        public void render(ItemStack stack, ItemTransforms.TransformType type, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
            Block block = Block.m_49814_((Item)stack.m_41720_());
            if (block instanceof BlockGaiasteelPylon) {
                BlockGaiasteelPylon pylon = (BlockGaiasteelPylon)block;
                forceTransform = type;
                super.render(stack, type, ms, buffers, light, overlay);
            }
        }
    }
}

