/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.init.ModFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record NestBiomeModifier(HolderSet<Biome> biomes, GenerationStep.Decoration generationStage, HolderSet<PlacedFeature> features, float temperature) implements BiomeModifier
{
    private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
        try {
            return DataResult.success((Object)GenerationStep.Decoration.valueOf((String)name));
        }
        catch (Exception e) {
            return DataResult.error((String)("Not a decoration stage: " + name));
        }
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome) && this.temperature > builder.getClimateSettings().getTemperature()) {
            BiomeGenerationSettingsBuilder generation = builder.getGenerationSettings();
            this.features.forEach(holder -> generation.m_204201_(this.generationStage, holder));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ModFeatures.NEST_BIOME_MODIFIER.get();
    }

    public static Codec<NestBiomeModifier> makeCodec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(NestBiomeModifier::biomes), (App)Codec.STRING.comapFlatMap(NestBiomeModifier::generationStageFromString, Enum::toString).fieldOf("generation_stage").forGetter(NestBiomeModifier::generationStage), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(NestBiomeModifier::features), (App)Codec.FLOAT.fieldOf("maxTemperature").forGetter(NestBiomeModifier::temperature)).apply((Applicative)builder, NestBiomeModifier::new));
    }
}

