/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.container;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.container.CustomSync;
import tfar.dankstorage.inventory.DankSlot;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.world.DankInventory;

public abstract class AbstractDankMenu
extends AbstractContainerMenu {
    public final int rows;
    public final Inventory playerInventory;
    public DankInventory dankInventory;
    protected final DataSlot pickup;

    public AbstractDankMenu(MenuType<?> type, int windowId, Inventory playerInventory, DankInventory dankInventory) {
        super(type, windowId);
        this.rows = dankInventory.dankStats.slots / 9;
        this.playerInventory = playerInventory;
        this.dankInventory = dankInventory;
        this.m_38884_(dankInventory);
        if (!playerInventory.f_35978_.f_19853_.f_46443_) {
            this.m_150416_(new CustomSync((ServerPlayer)playerInventory.f_35978_));
        }
        this.pickup = playerInventory.f_35978_.f_19853_.f_46443_ ? DataSlot.m_39401_() : this.getServerPickupData();
        this.m_38895_(this.pickup);
    }

    protected abstract DataSlot getServerPickupData();

    public PickupMode getMode() {
        return PickupMode.PICKUP_MODES[this.pickup.m_6501_()];
    }

    public static boolean canItemQuickReplace(@Nullable Slot slot, @Nonnull ItemStack stack, boolean stackSizeMatters) {
        boolean flag;
        boolean bl = flag = slot == null || !slot.m_6657_();
        if (slot != null) {
            ItemStack slotStack = slot.m_7993_();
            if (!flag && stack.m_41656_(slotStack) && ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)stack)) {
                return slotStack.m_41613_() + (stackSizeMatters ? 0 : stack.m_41613_()) <= slot.m_5866_(slotStack);
            }
        }
        return flag;
    }

    protected void addDankSlots() {
        int slotIndex = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 18;
                this.m_38897_((Slot)new DankSlot(this.dankInventory, slotIndex, x, y));
                ++slotIndex;
            }
        }
    }

    protected void addPlayerSlots(Inventory playerinventory) {
        int row;
        int yStart = 32 + 18 * this.rows;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + yStart;
                this.m_38897_(new Slot((Container)playerinventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = yStart + 58;
            this.m_38897_(new Slot((Container)playerinventory, row, x, y));
        }
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index < this.rows * 9 ? !this.m_38903_(slotStack, this.rows * 9, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.rows * 9, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_150430_(int slotId, int dragType, ClickType clickType, Player player) {
        block37: {
            block44: {
                block42: {
                    ClickAction clickaction;
                    block43: {
                        block41: {
                            block35: {
                                block40: {
                                    ItemStack itemstack;
                                    block39: {
                                        block38: {
                                            block36: {
                                                if (clickType != ClickType.QUICK_CRAFT) break block35;
                                                int i = this.f_38846_;
                                                this.f_38846_ = AbstractDankMenu.m_38947_((int)dragType);
                                                if (i == 1 && this.f_38846_ == 2 || i == this.f_38846_) break block36;
                                                this.m_38951_();
                                                break block37;
                                            }
                                            if (!this.m_142621_().m_41619_()) break block38;
                                            this.m_38951_();
                                            break block37;
                                        }
                                        if (this.f_38846_ != 0) break block39;
                                        this.f_38845_ = AbstractDankMenu.m_38928_((int)dragType);
                                        if (AbstractDankMenu.m_38862_((int)this.f_38845_, (Player)player)) {
                                            this.f_38846_ = 1;
                                            this.f_38847_.clear();
                                        } else {
                                            this.m_38951_();
                                        }
                                        break block37;
                                    }
                                    if (this.f_38846_ != 1) break block40;
                                    Slot slot = (Slot)this.f_38839_.get(slotId);
                                    if (!AbstractDankMenu.canItemQuickReplace(slot, itemstack = this.m_142621_(), true) || !slot.m_5857_(itemstack) || this.f_38845_ != 2 && itemstack.m_41613_() <= this.f_38847_.size() || !this.m_5622_(slot)) break block37;
                                    this.f_38847_.add(slot);
                                    break block37;
                                }
                                if (this.f_38846_ == 2) {
                                    if (!this.f_38847_.isEmpty()) {
                                        if (this.f_38847_.size() == 1) {
                                            int l = ((Slot)this.f_38847_.iterator().next()).f_40219_;
                                            this.m_38951_();
                                            this.m_150430_(l, this.f_38845_, ClickType.PICKUP, player);
                                            return;
                                        }
                                        ItemStack itemstack3 = this.m_142621_().m_41777_();
                                        int j1 = this.m_142621_().m_41613_();
                                        for (Slot slot1 : this.f_38847_) {
                                            ItemStack itemstack1 = this.m_142621_();
                                            if (slot1 == null || !AbstractDankMenu.canItemQuickReplace(slot1, itemstack1, true) || !slot1.m_5857_(itemstack1) || this.f_38845_ != 2 && itemstack1.m_41613_() < this.f_38847_.size() || !this.m_5622_(slot1)) continue;
                                            ItemStack itemstack2 = itemstack3.m_41777_();
                                            int j = slot1.m_6657_() ? slot1.m_7993_().m_41613_() : 0;
                                            AbstractDankMenu.m_38922_((Set)this.f_38847_, (int)this.f_38845_, (ItemStack)itemstack2, (int)j);
                                            int k = Math.min(itemstack2.m_41741_(), slot1.m_5866_(itemstack2));
                                            if (itemstack2.m_41613_() > k) {
                                                itemstack2.m_41764_(k);
                                            }
                                            j1 -= itemstack2.m_41613_() - j;
                                            slot1.m_5852_(itemstack2);
                                        }
                                        itemstack3.m_41764_(j1);
                                        this.m_142503_(itemstack3);
                                    }
                                    this.m_38951_();
                                } else {
                                    this.m_38951_();
                                }
                                break block37;
                            }
                            if (this.f_38846_ == 0) break block41;
                            this.m_38951_();
                            break block37;
                        }
                        if (clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1) break block42;
                        ClickAction clickAction = clickaction = dragType == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                        if (slotId != -999) break block43;
                        if (this.m_142621_().m_41619_()) break block37;
                        if (clickaction == ClickAction.PRIMARY) {
                            player.m_36176_(this.m_142621_(), true);
                            this.m_142503_(ItemStack.f_41583_);
                        } else {
                            player.m_36176_(this.m_142621_().m_41620_(1), true);
                        }
                        break block37;
                    }
                    if (clickType == ClickType.QUICK_MOVE) {
                        if (slotId < 0) {
                            return;
                        }
                        Slot slot6 = (Slot)this.f_38839_.get(slotId);
                        if (!slot6.m_8010_(player)) {
                            return;
                        }
                        ItemStack itemstack9 = this.m_7648_(player, slotId);
                        while (!itemstack9.m_41619_() && ItemStack.m_41746_((ItemStack)slot6.m_7993_(), (ItemStack)itemstack9)) {
                            itemstack9 = this.m_7648_(player, slotId);
                        }
                    } else {
                        if (slotId < 0) {
                            return;
                        }
                        Slot slot7 = (Slot)this.f_38839_.get(slotId);
                        ItemStack itemstack10 = slot7.m_7993_();
                        ItemStack carried = this.m_142621_();
                        player.m_141945_(carried, slot7.m_7993_(), clickaction);
                        if (!carried.m_150926_(slot7, clickaction, player) && !itemstack10.m_150932_(carried, slot7, clickaction, player, this.createCarriedSlotAccess())) {
                            if (itemstack10.m_41619_()) {
                                if (!carried.m_41619_()) {
                                    int l2 = clickaction == ClickAction.PRIMARY ? carried.m_41613_() : 1;
                                    this.m_142503_(slot7.m_150656_(carried, l2));
                                }
                            } else if (slot7.m_8010_(player)) {
                                if (carried.m_41619_()) {
                                    int max = itemstack10.m_41741_();
                                    int i3 = clickaction == ClickAction.PRIMARY ? max : (max + 1) / 2;
                                    Optional optional1 = slot7.m_150641_(i3, Integer.MAX_VALUE, player);
                                    optional1.ifPresent(stack -> {
                                        this.m_142503_((ItemStack)stack);
                                        slot7.m_142406_(player, stack);
                                    });
                                } else if (slot7.m_5857_(carried)) {
                                    if (ItemStack.m_150942_((ItemStack)itemstack10, (ItemStack)carried)) {
                                        int j3 = clickaction == ClickAction.PRIMARY ? carried.m_41613_() : 1;
                                        this.m_142503_(slot7.m_150656_(carried, j3));
                                    } else if (carried.m_41613_() <= slot7.m_5866_(carried)) {
                                        slot7.m_5852_(carried);
                                        this.m_142503_(itemstack10);
                                    }
                                } else if (ItemStack.m_150942_((ItemStack)itemstack10, (ItemStack)carried)) {
                                    Optional optional = slot7.m_150641_(itemstack10.m_41613_(), carried.m_41741_() - carried.m_41613_(), player);
                                    optional.ifPresent(stack -> {
                                        carried.m_41769_(stack.m_41613_());
                                        slot7.m_142406_(player, stack);
                                    });
                                }
                            }
                        }
                        slot7.m_6654_();
                    }
                    break block37;
                }
                if (clickType == ClickType.SWAP) break block37;
                if (clickType != ClickType.CLONE || !player.m_150110_().f_35937_ || !this.m_142621_().m_41619_() || slotId < 0) break block44;
                Slot slot5 = (Slot)this.f_38839_.get(slotId);
                if (!slot5.m_6657_()) break block37;
                ItemStack itemstack6 = slot5.m_7993_().m_41777_();
                itemstack6.m_41764_(itemstack6.m_41741_());
                this.m_142503_(itemstack6);
                break block37;
            }
            if (clickType == ClickType.THROW && this.m_142621_().m_41619_() && slotId >= 0) {
                Slot slot4 = (Slot)this.f_38839_.get(slotId);
                int i1 = dragType == 0 ? 1 : slot4.m_7993_().m_41613_();
                ItemStack itemstack8 = slot4.m_150647_(i1, Integer.MAX_VALUE, player);
                player.m_36176_(itemstack8, true);
            } else if (clickType == ClickType.PICKUP_ALL && slotId >= 0) {
                Slot slot3 = (Slot)this.f_38839_.get(slotId);
                ItemStack itemstack5 = this.m_142621_();
                if (!(itemstack5.m_41619_() || slot3.m_6657_() && slot3.m_8010_(player))) {
                    int k1 = dragType == 0 ? 0 : this.f_38839_.size() - 1;
                    int j2 = dragType == 0 ? 1 : -1;
                    for (int k2 = 0; k2 < 2; ++k2) {
                        for (int k3 = k1; k3 >= 0 && k3 < this.f_38839_.size() && itemstack5.m_41613_() < itemstack5.m_41741_(); k3 += j2) {
                            Slot slot8 = (Slot)this.f_38839_.get(k3);
                            if (!slot8.m_6657_() || !AbstractDankMenu.canItemQuickReplace(slot8, itemstack5, true) || !slot8.m_8010_(player) || !this.m_5882_(itemstack5, slot8)) continue;
                            ItemStack itemstack12 = slot8.m_7993_();
                            if (k2 == 0 && itemstack12.m_41613_() == itemstack12.m_41741_()) continue;
                            ItemStack itemstack13 = slot8.m_150647_(itemstack12.m_41613_(), itemstack5.m_41741_() - itemstack5.m_41613_(), player);
                            itemstack5.m_41769_(itemstack13.m_41613_());
                        }
                    }
                }
            }
        }
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return AbstractDankMenu.this.m_142621_();
            }

            public boolean m_142104_(ItemStack itemStack) {
                AbstractDankMenu.this.m_142503_(itemStack);
                return true;
            }
        };
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return true;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        Slot slot;
        boolean didSomething = false;
        int i = startIndex;
        if (reverse) {
            i = endIndex - 1;
        }
        while (!stack.m_41619_() && !(!reverse ? i >= endIndex : i < startIndex)) {
            slot = (Slot)this.f_38839_.get(i);
            ItemStack slotStack = slot.m_7993_();
            if (!slotStack.m_41619_() && slotStack.m_41720_() == stack.m_41720_() && ItemStack.m_41658_((ItemStack)stack, (ItemStack)slotStack)) {
                int maxSize;
                int combinedCount = slotStack.m_41613_() + stack.m_41613_();
                if (combinedCount <= (maxSize = slot.m_5866_(slotStack))) {
                    stack.m_41764_(0);
                    slotStack.m_41764_(combinedCount);
                    slot.m_6654_();
                    didSomething = true;
                } else if (slotStack.m_41613_() < maxSize) {
                    stack.m_41774_(maxSize - slotStack.m_41613_());
                    slotStack.m_41764_(maxSize);
                    slot.m_6654_();
                    didSomething = true;
                }
            }
            i += reverse ? -1 : 1;
        }
        if (!stack.m_41619_()) {
            i = reverse ? endIndex - 1 : startIndex;
            while (!(!reverse ? i >= endIndex : i < startIndex)) {
                slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot.m_7993_();
                if (itemstack1.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41613_() > slot.m_5866_(stack)) {
                        slot.m_5852_(stack.m_41620_(slot.m_5866_(stack)));
                    } else {
                        slot.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot.m_6654_();
                    didSomething = true;
                    break;
                }
                i += reverse ? -1 : 1;
            }
        }
        return didSomething;
    }

    public void m_38946_() {
        super.m_38946_();
        for (int i = 0; i < this.dankInventory.dankStats.slots; ++i) {
            DankPacketHandler.sendGhostItemSlot((ServerPlayer)this.playerInventory.f_35978_, this.f_38840_, i, this.dankInventory.getGhostItem(i));
        }
    }

    public abstract void setFrequency(int var1);
}

