/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.client.DankTooltip;

public class ClientDankTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/gui/container/bundle.png");
    private static final int MARGIN_Y = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int TEX_SIZE = 128;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 18;
    private final NonNullList<ItemStack> items;
    private final int selected;

    public ClientDankTooltip(DankTooltip bundleTooltip) {
        this.items = bundleTooltip.getItems();
        this.selected = bundleTooltip.getSelected();
    }

    public int m_142103_() {
        return this.gridSizeY() * 18 + 4;
    }

    public int m_142069_(Font font) {
        return this.gridSizeX() * 18;
    }

    public void m_183452_(Font font, int i, int j, PoseStack poseStack, ItemRenderer itemRenderer, int k) {
        int gridSizeX = this.gridSizeX();
        int gridSizeY = this.gridSizeY();
        int slot = 0;
        for (int y1 = 0; y1 < gridSizeY; ++y1) {
            for (int x1 = 0; x1 < gridSizeX; ++x1) {
                int q = i + x1 * 18;
                int r = j + y1 * 18;
                this.renderSlot(q, r, slot++, font, poseStack, itemRenderer, k);
            }
        }
    }

    private void renderSlot(int i, int j, int slot, Font font, PoseStack poseStack, ItemRenderer itemRenderer, int l) {
        ItemStack itemStack = (ItemStack)this.items.get(slot);
        this.blit(poseStack, i, j, l, Texture.SLOT);
        itemRenderer.m_174253_(itemStack, i + 1, j + 1, slot);
        itemRenderer.m_115169_(font, itemStack, i + 1, j + 1);
        if (slot == this.selected) {
            AbstractContainerScreen.m_169606_((PoseStack)poseStack, (int)(i + 1), (int)(j + 1), (int)l);
        }
    }

    private void blit(PoseStack poseStack, int i, int j, int k, Texture texture) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)i, (int)j, (int)k, (float)texture.x, (float)texture.y, (int)texture.w, (int)texture.h, (int)128, (int)128);
    }

    private int gridSizeX() {
        return 9;
    }

    private int gridSizeY() {
        return this.items.size() / this.gridSizeX();
    }

    static enum Texture {
        SLOT(0, 0, 18, 18),
        BLOCKED_SLOT(0, 40, 18, 18);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int j, int k, int l, int m) {
            this.x = j;
            this.y = k;
            this.w = l;
            this.h = m;
        }
    }
}

